"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNMUTE = exports.NO_ALERTS_ADDED_TO_CASE = exports.MUTE = exports.MARK_AS_UNTRACKED = exports.ERROR_FETCH_BROWSER_FIELDS = exports.ERROR_FETCH_ALERTS = exports.ALERTS_ALREADY_ATTACHED_TO_CASE = exports.ADD_TO_NEW_CASE = exports.ADD_TO_EXISTING_CASE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ERROR_FETCH_ALERTS = _i18n.i18n.translate('xpack.triggersActionsUI.components.alertTable.useFetchAlerts.errorMessageText', {
  defaultMessage: `An error has occurred on alerts search`
});
exports.ERROR_FETCH_ALERTS = ERROR_FETCH_ALERTS;
const ERROR_FETCH_BROWSER_FIELDS = _i18n.i18n.translate('xpack.triggersActionsUI.components.alertTable.useFetchBrowserFieldsCapabilities.errorMessageText', {
  defaultMessage: 'An error has occurred loading browser fields'
});
exports.ERROR_FETCH_BROWSER_FIELDS = ERROR_FETCH_BROWSER_FIELDS;
const ADD_TO_EXISTING_CASE = _i18n.i18n.translate('xpack.triggersActionsUI.alerts.table.actions.addToCase', {
  defaultMessage: 'Add to existing case'
});
exports.ADD_TO_EXISTING_CASE = ADD_TO_EXISTING_CASE;
const ADD_TO_NEW_CASE = _i18n.i18n.translate('xpack.triggersActionsUI.alerts.table.actions.addToNewCase', {
  defaultMessage: 'Add to new case'
});
exports.ADD_TO_NEW_CASE = ADD_TO_NEW_CASE;
const NO_ALERTS_ADDED_TO_CASE = _i18n.i18n.translate('xpack.triggersActionsUI.alerts.table.actions.noAlertsAddedToCaseTitle', {
  defaultMessage: 'No alerts added to the case'
});
exports.NO_ALERTS_ADDED_TO_CASE = NO_ALERTS_ADDED_TO_CASE;
const ALERTS_ALREADY_ATTACHED_TO_CASE = _i18n.i18n.translate('xpack.triggersActionsUI.alerts.table.actions.alertsAlreadyAttachedToCase', {
  defaultMessage: 'All selected alerts are already attached to the case'
});
exports.ALERTS_ALREADY_ATTACHED_TO_CASE = ALERTS_ALREADY_ATTACHED_TO_CASE;
const MARK_AS_UNTRACKED = _i18n.i18n.translate('xpack.triggersActionsUI.alerts.table.actions.markAsUntracked', {
  defaultMessage: 'Mark as untracked'
});
exports.MARK_AS_UNTRACKED = MARK_AS_UNTRACKED;
const MUTE = _i18n.i18n.translate('xpack.triggersActionsUI.alerts.table.actions.mute', {
  defaultMessage: 'Mute'
});
exports.MUTE = MUTE;
const UNMUTE = _i18n.i18n.translate('xpack.triggersActionsUI.alerts.table.actions.unmute', {
  defaultMessage: 'Unmute'
});
exports.UNMUTE = UNMUTE;