"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.systemCells = exports.SystemCellFactory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _default_cell = require("./default_cell");
var _alert_lifecycle_status_cell = require("./alert_lifecycle_status_cell");
var _cell = require("../cases/cell");
var _cell2 = require("../maintenance_windows/cell");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const systemCells = [_ruleDataUtils.ALERT_STATUS, _ruleDataUtils.ALERT_CASE_IDS, _ruleDataUtils.ALERT_MAINTENANCE_WINDOW_IDS];
exports.systemCells = systemCells;
const SystemCellFactoryComponent = props => {
  const {
    columnId
  } = props;
  const cellComponents = (0, _react.useMemo)(() => ({
    [_ruleDataUtils.ALERT_STATUS]: _alert_lifecycle_status_cell.AlertLifecycleStatusCell,
    [_ruleDataUtils.ALERT_CASE_IDS]: _cell.CasesCell,
    [_ruleDataUtils.ALERT_MAINTENANCE_WINDOW_IDS]: _cell2.MaintenanceWindowCell
  }), []);
  if (cellComponents[columnId]) {
    const CellComponent = cellComponents[columnId];
    return /*#__PURE__*/_react.default.createElement(CellComponent, props);
  }
  return /*#__PURE__*/_react.default.createElement(_default_cell.DefaultCell, props);
};
SystemCellFactoryComponent.displayName = 'SystemCellFactory';
const SystemCellFactory = /*#__PURE__*/(0, _react.memo)(SystemCellFactoryComponent);
exports.SystemCellFactory = SystemCellFactory;