"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _types = require("../../../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NAME_LABEL = _i18n.i18n.translate('xpack.triggersActionsUI.sections.alertsTable.alertsFlyout.name', {
  defaultMessage: 'Name'
});
const REASON_LABEL = _i18n.i18n.translate('xpack.triggersActionsUI.sections.alertsTable.alertsFlyout.reason', {
  defaultMessage: 'Reason'
});
const AlertsFlyoutBody = ({
  alert,
  isLoading
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "spaceBetween",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, NAME_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 1
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "alertsFlyoutName"
  }, (0, _lodash.get)(alert, _types.AlertsField.name, [])[0])), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, REASON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    isLoading: isLoading
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "alertsFlyoutReason"
  }, (0, _lodash.get)(alert, _types.AlertsField.reason, [])[0]))));
};

// eslint-disable-next-line import/no-default-export
var _default = AlertsFlyoutBody;
exports.default = _default;
module.exports = exports.default;