"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alertingFrameworkHealth = alertingFrameworkHealth;
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rewriteAlertingFrameworkHealth = ({
  decryption_health: decryptionHealth,
  execution_health: executionHealth,
  read_health: readHealth,
  ...res
}) => ({
  decryptionHealth,
  executionHealth,
  readHealth,
  ...res
});
const rewriteBodyRes = ({
  is_sufficiently_secure: isSufficientlySecure,
  has_permanent_encryption_key: hasPermanentEncryptionKey,
  // eslint-disable-next-line @typescript-eslint/no-shadow
  alerting_framework_health: alertingFrameworkHealth,
  ...res
}) => ({
  isSufficientlySecure,
  hasPermanentEncryptionKey,
  alertingFrameworkHealth,
  ...res
});
async function alertingFrameworkHealth({
  http
}) {
  const res = await http.get(`${_constants.BASE_ALERTING_API_PATH}/_health`);
  const alertingFrameworkHealthRewrited = rewriteAlertingFrameworkHealth(res.alerting_framework_health);
  return {
    ...rewriteBodyRes(res),
    alertingFrameworkHealth: alertingFrameworkHealthRewrited
  };
}