"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRule = createRule;
var _constants = require("../../constants");
var _common_transformations = require("./common_transformations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rewriteBodyRequest = ({
  ruleTypeId,
  actions,
  ...res
}) => ({
  ...res,
  rule_type_id: ruleTypeId,
  actions: actions.map(({
    group,
    id,
    params,
    frequency,
    alertsFilter,
    useAlertDataForTemplate
  }) => ({
    group,
    id,
    params,
    frequency: {
      notify_when: frequency.notifyWhen,
      throttle: frequency.throttle,
      summary: frequency.summary
    },
    alerts_filter: alertsFilter,
    ...(typeof useAlertDataForTemplate !== 'undefined' ? {
      use_alert_data_for_template: useAlertDataForTemplate
    } : {})
  }))
});
async function createRule({
  http,
  rule
}) {
  const res = await http.post(`${_constants.BASE_ALERTING_API_PATH}/rule`, {
    body: JSON.stringify(rewriteBodyRequest(rule))
  });
  return (0, _common_transformations.transformRule)(res);
}