"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkActionFormActionTypeEnabled = checkActionFormActionTypeEnabled;
exports.checkActionTypeEnabled = checkActionTypeEnabled;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../common/constants");
require("./check_action_type_enabled.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLicenseCheckResult = actionType => {
  return {
    isEnabled: false,
    message: _i18n.i18n.translate('xpack.triggersActionsUI.checkActionTypeEnabled.actionTypeDisabledByLicenseMessage', {
      defaultMessage: 'This connector requires a {minimumLicenseRequired} license.',
      values: {
        minimumLicenseRequired: (0, _lodash.upperFirst)(actionType.minimumLicenseRequired)
      }
    }),
    messageCard: /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
      titleSize: "xs",
      title: _i18n.i18n.translate('xpack.triggersActionsUI.licenseCheck.actionTypeDisabledByLicenseMessageTitle', {
        defaultMessage: 'This feature requires a {minimumLicenseRequired} license.',
        values: {
          minimumLicenseRequired: (0, _lodash.upperFirst)(actionType.minimumLicenseRequired)
        }
      })
      // The "re-enable" terminology is used here because this message is used when an alert
      // action was previously enabled and needs action to be re-enabled.
      ,
      description: _i18n.i18n.translate('xpack.triggersActionsUI.licenseCheck.actionTypeDisabledByLicenseMessageDescription', {
        defaultMessage: 'To re-enable this action, please upgrade your license.'
      }),
      className: "actCheckActionTypeEnabled__disabledActionWarningCard",
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _constants.VIEW_LICENSE_OPTIONS_LINK,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        defaultMessage: "View license options",
        id: "xpack.triggersActionsUI.licenseCheck.actionTypeDisabledByLicenseLinkTitle"
      }))
    })
  };
};
const configurationCheckResult = {
  isEnabled: false,
  message: _i18n.i18n.translate('xpack.triggersActionsUI.checkActionTypeEnabled.actionTypeDisabledByConfigMessage', {
    defaultMessage: 'This connector is disabled by the Kibana configuration.'
  }),
  messageCard: /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    title: _i18n.i18n.translate('xpack.triggersActionsUI.licenseCheck.actionTypeDisabledByConfigMessageTitle', {
      defaultMessage: 'This feature is disabled by the Kibana configuration.'
    }),
    description: "",
    className: "actCheckActionTypeEnabled__disabledActionWarningCard"
  })
};
function checkActionTypeEnabled(actionType) {
  if ((actionType === null || actionType === void 0 ? void 0 : actionType.enabledInLicense) === false) {
    return getLicenseCheckResult(actionType);
  }
  if ((actionType === null || actionType === void 0 ? void 0 : actionType.enabledInConfig) === false) {
    return configurationCheckResult;
  }
  return {
    isEnabled: true
  };
}
function checkActionFormActionTypeEnabled(actionType, preconfiguredConnectors) {
  if ((actionType === null || actionType === void 0 ? void 0 : actionType.enabledInLicense) === false) {
    return getLicenseCheckResult(actionType);
  }
  if ((actionType === null || actionType === void 0 ? void 0 : actionType.enabledInConfig) === false &&
  // do not disable action type if it contains preconfigured connectors (is preconfigured)
  !preconfiguredConnectors.find(preconfiguredConnector => preconfiguredConnector.actionTypeId === actionType.id)) {
    return configurationCheckResult;
  }
  return {
    isEnabled: true
  };
}