"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateRuleSettings = void 0;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _kibana = require("../../common/lib/kibana");
var _update_flapping_settings = require("../lib/rule_api/update_flapping_settings");
var _update_query_delay_settings = require("../lib/rule_api/update_query_delay_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUpdateRuleSettings = props => {
  const {
    onSave,
    onClose,
    setUpdatingRulesSettings
  } = props;
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const mutationFn = async settings => {
    const updates = [];
    if (settings.flapping) {
      updates.push((0, _update_flapping_settings.updateFlappingSettings)({
        http,
        flappingSettings: settings.flapping
      }));
    }
    if (settings.queryDelay) {
      updates.push((0, _update_query_delay_settings.updateQueryDelaySettings)({
        http,
        queryDelaySettings: settings.queryDelay
      }));
    }
    return await Promise.all(updates);
  };
  return (0, _reactQuery.useMutation)({
    mutationFn,
    onMutate: () => {
      onClose();
      setUpdatingRulesSettings === null || setUpdatingRulesSettings === void 0 ? void 0 : setUpdatingRulesSettings(true);
    },
    onSuccess: () => {
      toasts.addSuccess(_i18n.i18n.translate('xpack.triggersActionsUI.rulesSettings.modal.updateRulesSettingsSuccess', {
        defaultMessage: 'Rules settings updated successfully.'
      }));
    },
    onError: () => {
      toasts.addDanger(_i18n.i18n.translate('xpack.triggersActionsUI.rulesSettings.modal.updateRulesSettingsFailure', {
        defaultMessage: 'Failed to update rules settings.'
      }));
    },
    onSettled: () => {
      setUpdatingRulesSettings === null || setUpdatingRulesSettings === void 0 ? void 0 : setUpdatingRulesSettings(false);
      onSave === null || onSave === void 0 ? void 0 : onSave();
    }
  });
};
exports.useUpdateRuleSettings = useUpdateRuleSettings;