"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.triggersActionsUiQueriesKeys = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const triggersActionsUiQueriesKeys = {
  all: ['triggersActionsUi'],
  alertsTable: () => [...triggersActionsUiQueriesKeys.all, 'alertsTable'],
  cases: () => [...triggersActionsUiQueriesKeys.alertsTable(), 'cases'],
  mutedAlerts: () => [...triggersActionsUiQueriesKeys.alertsTable(), 'mutedAlerts'],
  casesBulkGet: caseIds => [...triggersActionsUiQueriesKeys.cases(), 'bulkGet', caseIds],
  maintenanceWindows: () => [...triggersActionsUiQueriesKeys.alertsTable(), 'maintenanceWindows'],
  maintenanceWindowsBulkGet: maintenanceWindowIds => [...triggersActionsUiQueriesKeys.maintenanceWindows(), 'bulkGet', maintenanceWindowIds]
};
exports.triggersActionsUiQueriesKeys = triggersActionsUiQueriesKeys;