"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextFieldWithMessageVariables = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _alertsUiShared = require("@kbn/alerts-ui-shared");
var _lib = require("../lib");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Wrapper = ({
  children,
  wrapField,
  formRowProps,
  button
}) => wrapField ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({}, formRowProps, {
  labelAppend: button
}), children) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
const TextFieldWithMessageVariables = ({
  buttonTitle,
  messageVariables,
  paramsProperty,
  index,
  inputTargetValue,
  editAction,
  errors,
  formRowProps,
  defaultValue,
  wrapField = false,
  showButtonTitle
}) => {
  const [currentTextElement, setCurrentTextElement] = (0, _react.useState)(null);
  const onSelectMessageVariable = (0, _react.useCallback)(variable => {
    var _currentTextElement$s, _currentTextElement$s2;
    const templatedVar = (0, _lib.templateActionVariable)(variable);
    const startPosition = (_currentTextElement$s = currentTextElement === null || currentTextElement === void 0 ? void 0 : currentTextElement.selectionStart) !== null && _currentTextElement$s !== void 0 ? _currentTextElement$s : 0;
    const endPosition = (_currentTextElement$s2 = currentTextElement === null || currentTextElement === void 0 ? void 0 : currentTextElement.selectionEnd) !== null && _currentTextElement$s2 !== void 0 ? _currentTextElement$s2 : 0;
    const newValue = (inputTargetValue !== null && inputTargetValue !== void 0 ? inputTargetValue : '').substring(0, startPosition) + templatedVar + (inputTargetValue !== null && inputTargetValue !== void 0 ? inputTargetValue : '').substring(endPosition, (inputTargetValue !== null && inputTargetValue !== void 0 ? inputTargetValue : '').length);
    editAction(paramsProperty, newValue, index);
  }, [currentTextElement, editAction, index, inputTargetValue, paramsProperty]);
  const onChangeWithMessageVariable = e => {
    editAction(paramsProperty, e.target.value, index);
  };
  const VariableButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_alertsUiShared.AddMessageVariables, {
    buttonTitle: buttonTitle,
    messageVariables: messageVariables,
    onSelectEventHandler: onSelectMessageVariable,
    paramsProperty: paramsProperty,
    showButtonTitle: showButtonTitle
  }), [buttonTitle, messageVariables, onSelectMessageVariable, paramsProperty, showButtonTitle]);
  return /*#__PURE__*/_react.default.createElement(Wrapper, {
    wrapField: wrapField,
    formRowProps: formRowProps,
    button: VariableButton
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    name: paramsProperty,
    id: `${paramsProperty}Id`,
    isInvalid: errors && errors.length > 0 && inputTargetValue !== undefined,
    "data-test-subj": `${paramsProperty}Input`,
    value: inputTargetValue || '',
    defaultValue: defaultValue,
    onChange: e => onChangeWithMessageVariable(e),
    onFocus: e => {
      setCurrentTextElement(e.target);
    },
    onBlur: e => {
      if (!inputTargetValue) {
        editAction(paramsProperty, '', index);
      }
    },
    append: wrapField ? undefined : VariableButton
  }));
};
exports.TextFieldWithMessageVariables = TextFieldWithMessageVariables;