"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyConnectorsPrompt = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
require("./empty_connectors_prompt.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyConnectorsPrompt = ({
  onCTAClicked,
  docLinks
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
  "data-test-subj": "createFirstConnectorEmptyPrompt",
  title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoSlack",
    size: "xl",
    className: "actEmptyConnectorsPrompt__logo"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoGmail",
    size: "xl",
    className: "actEmptyConnectorsPrompt__logo"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoWebhook",
    size: "xl",
    className: "actEmptyConnectorsPrompt__logo"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.components.emptyConnectorsPrompt.addConnectorEmptyTitle",
    defaultMessage: "Create your first connector"
  })))),
  body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.components.emptyConnectorsPrompt.addConnectorEmptyBody",
    defaultMessage: "Configure various third-party services to Kibana."
  })),
  actions: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "createFirstActionButton",
    key: "create-action",
    fill: true,
    iconType: "plusInCircle",
    iconSide: "left",
    onClick: onCTAClicked
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.components.emptyConnectorsPrompt.addConnectorButtonLabel",
    defaultMessage: "Create connector"
  })), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "documentationButton",
    key: "documentation-button",
    target: "_blank",
    href: docLinks.links.alerting.connectors,
    iconType: "help"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.actionsConnectorsList.documentationButtonLabel",
    defaultMessage: "Documentation"
  })))
});
exports.EmptyConnectorsPrompt = EmptyConnectorsPrompt;