"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isDiscoverActionDisabled = exports.discoverActionNameText = exports.DiscoverActionName = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/constants");
var _common = require("../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const discoverActionNameText = _i18n.i18n.translate('xpack.transform.transformList.discoverActionNameText', {
  defaultMessage: 'View in Discover'
});
exports.discoverActionNameText = discoverActionNameText;
const isDiscoverActionDisabled = (items, forceDisable, dataViewExists) => {
  var _item$stats;
  if (items.length !== 1) {
    return true;
  }
  const item = items[0];

  // Disable discover action if it's a batch transform and was never started
  const stoppedTransform = ((_item$stats = item.stats) === null || _item$stats === void 0 ? void 0 : _item$stats.state) === _constants.TRANSFORM_STATE.STOPPED;
  const transformProgress = (0, _common.getTransformProgress)(item);
  const isBatchTransform = typeof item.config.sync === 'undefined';
  const transformNeverStarted = stoppedTransform === true && transformProgress === undefined && isBatchTransform === true;
  return forceDisable === true || dataViewExists === false || transformNeverStarted === true;
};
exports.isDiscoverActionDisabled = isDiscoverActionDisabled;
const DiscoverActionName = ({
  dataViewExists,
  items
}) => {
  var _item$stats2;
  const isBulkAction = items.length > 1;
  const item = items[0];

  // Disable discover action if it's a batch transform and was never started
  const stoppedTransform = ((_item$stats2 = item.stats) === null || _item$stats2 === void 0 ? void 0 : _item$stats2.state) === _constants.TRANSFORM_STATE.STOPPED;
  const transformProgress = (0, _common.getTransformProgress)(item);
  const isBatchTransform = typeof item.config.sync === 'undefined';
  const transformNeverStarted = stoppedTransform && transformProgress === undefined && isBatchTransform === true;
  let disabledTransformMessage;
  if (isBulkAction === true) {
    disabledTransformMessage = _i18n.i18n.translate('xpack.transform.transformList.discoverTransformBulkToolTip', {
      defaultMessage: 'Links to Discover are not supported as a bulk action.'
    });
  } else if (!dataViewExists) {
    disabledTransformMessage = _i18n.i18n.translate('xpack.transform.transformList.discoverTransformNoDataViewToolTip', {
      defaultMessage: `A Kibana data view is required for the destination index to be viewable in Discover`
    });
  } else if (transformNeverStarted) {
    disabledTransformMessage = _i18n.i18n.translate('xpack.transform.transformList.discoverTransformToolTip', {
      defaultMessage: `The transform needs to be started before it's available in Discover.`
    });
  }
  if (typeof disabledTransformMessage !== 'undefined') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: disabledTransformMessage
    }, /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "transformDiscoverActionNameText disabled"
    }, discoverActionNameText));
  }
  return /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "transformDiscoverActionNameText enabled"
  }, discoverActionNameText);
};
exports.DiscoverActionName = DiscoverActionName;