"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSearchItems = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _data_view = require("../../../../common/types/data_view");
var _app_dependencies = require("../../app_dependencies");
var _common = require("./common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSearchItems = defaultSavedObjectId => {
  const [savedObjectId, setSavedObjectId] = (0, _react.useState)(defaultSavedObjectId);
  const [error, setError] = (0, _react.useState)();
  const appDeps = (0, _app_dependencies.useAppDependencies)();
  const dataViewsContract = appDeps.data.dataViews;
  const uiSettings = appDeps.uiSettings;
  const [searchItems, setSearchItems] = (0, _react.useState)(undefined);
  const isMounted = (0, _react.useRef)(true);
  (0, _react.useEffect)(() => {
    return () => {
      isMounted.current = false;
    };
  }, []);
  async function fetchSavedObject(id) {
    let fetchedDataView;
    let fetchedSavedSearch;
    try {
      fetchedDataView = await dataViewsContract.get(id);
    } catch (e) {
      // Just let fetchedDataView stay undefined in case it doesn't exist.
    }
    try {
      // If data view already found, no need to get saved search
      if (!fetchedDataView) {
        fetchedSavedSearch = await appDeps.savedSearch.get(id);
      }
    } catch (e) {
      // Just let fetchedSavedSearch stay undefined in case it doesn't exist.
    }
    if (isMounted.current) {
      if (!(0, _data_view.isDataView)(fetchedDataView) && fetchedSavedSearch === undefined) {
        setError(_i18n.i18n.translate('xpack.transform.searchItems.errorInitializationTitle', {
          defaultMessage: `An error occurred initializing the Kibana data view or saved search.`
        }));
        return;
      }
      setSearchItems((0, _common.createSearchItems)(fetchedDataView, fetchedSavedSearch, uiSettings));
      setError(undefined);
    }
  }
  (0, _react.useEffect)(() => {
    if (savedObjectId !== undefined) {
      fetchSavedObject(savedObjectId);
    }
    // Run this only when savedObjectId changes.
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [savedObjectId]);
  return {
    error,
    getDataViewIdByTitle: _common.getDataViewIdByTitle,
    loadDataViews: _common.loadDataViews,
    searchItems,
    setSavedObjectId
  };
};
exports.useSearchItems = useSearchItems;