"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResetTransforms = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _constants = require("../../../common/constants");
var _errors = require("../../../common/utils/errors");
var _app_dependencies = require("../app_dependencies");
var _components = require("../components");
var _use_refresh_transform_list = require("./use_refresh_transform_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useResetTransforms = () => {
  const {
    http,
    i18n: i18nStart,
    theme
  } = (0, _app_dependencies.useAppDependencies)();
  const refreshTransformList = (0, _use_refresh_transform_list.useRefreshTransformList)();
  const toastNotifications = (0, _app_dependencies.useToastNotifications)();
  const mutation = (0, _reactQuery.useMutation)({
    mutationFn: reqBody => http.post((0, _constants.addInternalBasePath)('reset_transforms'), {
      body: JSON.stringify(reqBody),
      version: '1'
    }),
    onError: error => toastNotifications.addDanger({
      title: _i18n.i18n.translate('xpack.transform.transformList.resetTransformGenericErrorMessage', {
        defaultMessage: 'An error occurred calling the API endpoint to reset transforms.'
      }),
      text: (0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_components.ToastNotificationText, {
        previewTextLength: 50,
        text: (0, _errors.getErrorMessage)(error)
      }), {
        theme,
        i18n: i18nStart
      })
    }),
    onSuccess: results => {
      for (const transformId in results) {
        // hasOwnProperty check to ensure only properties on object itself, and not its prototypes
        if (results.hasOwnProperty(transformId)) {
          var _status$transformRese;
          const status = results[transformId];
          if ((_status$transformRese = status.transformReset) !== null && _status$transformRese !== void 0 && _status$transformRese.error) {
            const error = status.transformReset.error.reason;
            toastNotifications.addDanger({
              title: _i18n.i18n.translate('xpack.transform.transformList.resetTransformErrorMessage', {
                defaultMessage: 'An error occurred resetting the transform {transformId}',
                values: {
                  transformId
                }
              }),
              text: (0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_components.ToastNotificationText, {
                previewTextLength: 50,
                text: error
              }), {
                theme,
                i18n: i18nStart
              })
            });
          }
        }
      }
      refreshTransformList();
    }
  });
  return mutation.mutate;
};
exports.useResetTransforms = useResetTransforms;