"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RedirectToTransformManagement = exports.RedirectToCreateTransform = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RedirectToTransformManagement = () => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
  to: `/${_constants.SECTION_SLUG.HOME}`
});
exports.RedirectToTransformManagement = RedirectToTransformManagement;
const RedirectToCreateTransform = ({
  savedObjectId
}) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
  push: true,
  to: `/${_constants.SECTION_SLUG.CREATE_TRANSFORM}/${savedObjectId}`
});
exports.RedirectToCreateTransform = RedirectToCreateTransform;