"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.MORE_ACTIONS = exports.FILTER_OUT_VALUE_KEYBOARD_SHORTCUT = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _accessibility = require("../../../../common/utils/accessibility");
var _tooltip_with_keyboard_shortcut = require("../../tooltip_with_keyboard_shortcut");
var _utils = require("../utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MORE_ACTIONS = _i18n.i18n.translate('xpack.timelines.hoverActions.moreActions', {
  defaultMessage: 'More actions'
});
exports.MORE_ACTIONS = MORE_ACTIONS;
const FILTER_OUT_VALUE_KEYBOARD_SHORTCUT = 'm';
exports.FILTER_OUT_VALUE_KEYBOARD_SHORTCUT = FILTER_OUT_VALUE_KEYBOARD_SHORTCUT;
const StyledEuiContextMenuPanel = (0, _styledComponents.default)(_eui.EuiContextMenuPanel)`
  visibility: inherit;
`;
const OverflowButton = /*#__PURE__*/_react.default.memo(({
  closePopOver,
  Component,
  defaultFocusedButtonRef,
  field,
  items,
  isOverflowPopoverOpen,
  keyboardEvent,
  ownFocus,
  onClick,
  showTooltip = false,
  value
}) => {
  (0, _react.useEffect)(() => {
    if (!ownFocus) {
      return;
    }
    if ((keyboardEvent === null || keyboardEvent === void 0 ? void 0 : keyboardEvent.key) === FILTER_OUT_VALUE_KEYBOARD_SHORTCUT) {
      (0, _accessibility.stopPropagationAndPreventDefault)(keyboardEvent);
      if (onClick != null) {
        onClick();
      }
    }
  }, [keyboardEvent, onClick, ownFocus]);
  const popover = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: Component ? /*#__PURE__*/_react.default.createElement(Component, {
      "aria-label": MORE_ACTIONS,
      buttonRef: defaultFocusedButtonRef,
      "data-test-subj": `more-actions-${field}`,
      icon: "boxesHorizontal",
      iconType: "boxesHorizontal",
      onClick: onClick,
      title: MORE_ACTIONS
    }, MORE_ACTIONS) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": MORE_ACTIONS,
      buttonRef: defaultFocusedButtonRef,
      className: "timelines__hoverActionButton",
      "data-test-subj": `more-actions-${field}`,
      iconSize: "s",
      iconType: "boxesHorizontal",
      onClick: onClick
    }),
    isOpen: isOverflowPopoverOpen,
    closePopover: closePopOver,
    panelPaddingSize: "none",
    panelClassName: "withHoverActions__popover",
    repositionOnScroll: true,
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(StyledEuiContextMenuPanel, {
    items: items
  })), [Component, defaultFocusedButtonRef, field, onClick, isOverflowPopoverOpen, closePopOver, items]);
  return showTooltip ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_tooltip_with_keyboard_shortcut.TooltipWithKeyboardShortcut, {
      additionalScreenReaderOnlyContext: (0, _utils.getAdditionalScreenReaderOnlyContext)({
        field,
        value
      }),
      content: MORE_ACTIONS,
      shortcut: FILTER_OUT_VALUE_KEYBOARD_SHORTCUT,
      showShortcut: ownFocus
    })
  }, popover) : popover;
});
exports.default = OverflowButton;
OverflowButton.displayName = 'OverflowButton';

// eslint-disable-next-line import/no-default-export