"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timelineEqlRequestOptionsSchema = void 0;
var _zod = require("zod");
var _filter_query = require("../model/filter_query");
var _runtime_mappings = require("../model/runtime_mappings");
var _sort = require("../model/sort");
var _request_paginated = require("./request_paginated");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const timelineEqlRequestOptionsSchema = _request_paginated.requestPaginated.extend({
  sort: _sort.sort,
  filterQuery: _filter_query.filterQuery,
  eventCategoryField: _zod.z.string().optional(),
  tiebreakerField: _zod.z.string().optional(),
  timestampField: _zod.z.string().optional(),
  fieldRequested: _zod.z.array(_zod.z.string()),
  size: _zod.z.number().optional(),
  runTimeMappings: _runtime_mappings.runtimeMappings.optional(),
  language: _zod.z.literal('eql')
});
exports.timelineEqlRequestOptionsSchema = timelineEqlRequestOptionsSchema;