"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextBasedLangEditor = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _public = require("@kbn/kibana-react-plugin/public");
var _kibana_services = require("./kibana_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const TextBasedLangEditor = props => {
  var _value$;
  const {
    loading,
    value
  } = (0, _useAsync.default)(() => {
    const startServicesPromise = (0, _kibana_services.untilPluginStartServicesReady)();
    const modulePromise = Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/text-based-editor')));
    return Promise.all([startServicesPromise, modulePromise]);
  }, []);
  const TextBasedLanguagesEditor = value === null || value === void 0 ? void 0 : (_value$ = value[1]) === null || _value$ === void 0 ? void 0 : _value$.default;
  const deps = value === null || value === void 0 ? void 0 : value[0];
  if (loading || !deps || !TextBasedLanguagesEditor) return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
  return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...deps
    }
  }, /*#__PURE__*/_react.default.createElement(TextBasedLanguagesEditor, (0, _extends2.default)({}, props, {
    isDarkMode: deps.darkMode
  })));
};
exports.TextBasedLangEditor = TextBasedLangEditor;