"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processorsFormatter = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const processorsFormatter = config => {
  const processors = [{
    add_fields: {
      fields: {
        'monitor.fleet_managed': true,
        config_id: config.config_id,
        test_run_id: config.test_run_id,
        run_once: config.run_once,
        'monitor.id': config['monitor.id'],
        'monitor.project.name': config['monitor.project.name'],
        'monitor.project.id': config['monitor.project.id'],
        meta: {
          space_id: config.space_id
        }
      },
      target: ''
    }
  }];
  return JSON.stringify(processors);
};
exports.processorsFormatter = processorsFormatter;