"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toSavedObjectContract = exports.toClientContract = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toClientContract = (attributes, agentPolicies) => {
  return attributes.locations.map(location => {
    const agPolicy = agentPolicies === null || agentPolicies === void 0 ? void 0 : agentPolicies.find(policy => policy.id === location.agentPolicyId);
    return {
      label: location.label,
      id: location.id,
      agentPolicyId: location.agentPolicyId,
      isServiceManaged: false,
      isInvalid: !Boolean(agPolicy),
      tags: location.tags,
      geo: location.geo,
      namespace: agPolicy === null || agPolicy === void 0 ? void 0 : agPolicy.namespace
    };
  });
};
exports.toClientContract = toClientContract;
const toSavedObjectContract = location => {
  return {
    label: location.label,
    id: location.id,
    agentPolicyId: location.agentPolicyId,
    tags: location.tags,
    isServiceManaged: false,
    geo: location.geo,
    namespace: location.namespace
  };
};
exports.toSavedObjectContract = toSavedObjectContract;