"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UptimePlugin = void 0;
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/core/public");
var _plugin = require("../common/constants/plugin");
var _ui = require("../common/constants/ui");
var _locators = require("./apps/locators");
var _kibana_services = require("./kibana_services");
var _alert_types = require("./apps/synthetics/lib/alert_types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
class UptimePlugin {
  constructor(initContext) {
    this.initContext = initContext;
  }
  setup(core, plugins) {
    _locators.locators.forEach(locator => {
      plugins.share.url.locators.create(locator);
    });
    registerSyntheticsRoutesWithNavigation(core, plugins);
    const appKeywords = ['Synthetics', 'availability', 'browser', 'checks', 'digital', 'reachability', 'reachable', 'response duration', 'response time', 'monitors', 'outside in', 'performance', 'pings', 'web performance', 'web perf'];

    // Register the Synthetics UI plugin
    core.application.register({
      id: 'synthetics',
      euiIconType: 'logoObservability',
      order: 8400,
      title: _plugin.PLUGIN.SYNTHETICS,
      category: _public.DEFAULT_APP_CATEGORIES.observability,
      keywords: appKeywords,
      deepLinks: [],
      mount: async params => {
        const [coreStart, corePlugins] = await core.getStartServices();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./apps/synthetics/render_app')));
        return renderApp(coreStart, plugins, corePlugins, params, this.initContext.env.mode.dev);
      }
    });
  }
  start(coreStart, pluginsStart) {
    const {
      triggersActionsUi
    } = pluginsStart;
    (0, _kibana_services.setStartServices)(coreStart);
    _alert_types.syntheticsAlertTypeInitializers.forEach(init => {
      const {
        observabilityRuleTypeRegistry
      } = pluginsStart.observability;
      const alertInitializer = init({
        core: coreStart,
        plugins: pluginsStart
      });
      if (!triggersActionsUi.ruleTypeRegistry.has(alertInitializer.id)) {
        observabilityRuleTypeRegistry.register(alertInitializer);
      }
    });
  }
  stop() {}
}
exports.UptimePlugin = UptimePlugin;
function registerSyntheticsRoutesWithNavigation(core, plugins) {
  plugins.observabilityShared.navigation.registerSections((0, _rxjs.from)(core.getStartServices()).pipe((0, _operators.map)(([coreStart]) => {
    var _coreStart$applicatio;
    if ((_coreStart$applicatio = coreStart.application.capabilities.uptime) !== null && _coreStart$applicatio !== void 0 && _coreStart$applicatio.show) {
      return [{
        label: 'Synthetics',
        sortKey: 499,
        entries: [{
          label: _i18n.i18n.translate('xpack.synthetics.overview.SyntheticsHeading', {
            defaultMessage: 'Monitors'
          }),
          app: 'synthetics',
          path: _ui.OVERVIEW_ROUTE,
          matchFullPath: true,
          ignoreTrailingSlash: true,
          isNewFeature: true
        }, {
          label: _i18n.i18n.translate('xpack.synthetics.certificatesPage.heading', {
            defaultMessage: 'TLS Certificates'
          }),
          app: 'synthetics',
          path: '/certificates',
          matchFullPath: true
        }]
      }];
    }
    return [];
  })));
}