"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stringifyUrlParams = void 0;
var _queryString = require("query-string");
var _client_defaults = require("../../../../../common/constants/synthetics/client_defaults");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  FOCUS_CONNECTOR_FIELD
} = _constants.CLIENT_DEFAULTS;
const {
  DATE_RANGE_START,
  DATE_RANGE_END,
  AUTOREFRESH_INTERVAL_SECONDS,
  AUTOREFRESH_IS_PAUSED
} = _client_defaults.CLIENT_DEFAULTS_SYNTHETICS;
const stringifyUrlParams = (params, ignoreEmpty = false) => {
  if (ignoreEmpty) {
    // We don't want to encode this values because they are often set to Date.now(), the relative
    // values in dateRangeStart are better for a URL.
    delete params.absoluteDateRangeStart;
    delete params.absoluteDateRangeEnd;
    replaceDefaults(params);
  }
  return `?${(0, _queryString.stringify)(params, {
    sort: false
  })}`;
};
exports.stringifyUrlParams = stringifyUrlParams;
const replaceDefaults = params => {
  Object.keys(params).forEach(key => {
    // @ts-ignore
    const val = params[key];
    if (val == null || val === '' || val === undefined) {
      // @ts-ignore
      delete params[key];
    }
    if (key === 'dateRangeStart' && val === DATE_RANGE_START) {
      delete params[key];
    }
    if (key === 'dateRangeEnd' && val === DATE_RANGE_END) {
      delete params[key];
    }
    if (key === 'refreshPaused' && val === AUTOREFRESH_IS_PAUSED) {
      delete params[key];
    }
    if (key === 'refreshInterval' && val === AUTOREFRESH_INTERVAL_SECONDS) {
      delete params[key];
    }
    if (key === 'focusConnectorField' && val === FOCUS_CONNECTOR_FIELD) {
      delete params[key];
    }
  });
  return params;
};