"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  uiReducer: true
};
exports.uiReducer = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _client_defaults = require("../../../../../common/constants/synthetics/client_defaults");
var _actions = require("./actions");
Object.keys(_actions).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _actions[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _actions[key];
    }
  });
});
var _selectors = require("./selectors");
Object.keys(_selectors).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _selectors[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _selectors[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  AUTOREFRESH_INTERVAL_SECONDS,
  AUTOREFRESH_IS_PAUSED
} = _client_defaults.CLIENT_DEFAULTS_SYNTHETICS;
const initialState = {
  alertFlyoutVisible: null,
  basePath: '',
  esKuery: '',
  searchText: '',
  integrationsPopoverOpen: null,
  monitorId: '',
  refreshInterval: AUTOREFRESH_INTERVAL_SECONDS,
  refreshPaused: AUTOREFRESH_IS_PAUSED
};
const uiReducer = (0, _toolkit.createReducer)(initialState, builder => {
  builder.addCase(_actions.toggleIntegrationsPopover, (state, action) => {
    state.integrationsPopoverOpen = action.payload;
  }).addCase(_actions.setAlertFlyoutVisible, (state, action) => {
    state.alertFlyoutVisible = action.payload;
  }).addCase(_actions.setBasePath, (state, action) => {
    state.basePath = action.payload;
  }).addCase(_actions.setEsKueryString, (state, action) => {
    state.esKuery = action.payload;
  }).addCase(_actions.setSearchTextAction, (state, action) => {
    state.searchText = action.payload;
  }).addCase(_actions.setSelectedMonitorId, (state, action) => {
    state.monitorId = action.payload;
  }).addCase(_actions.setRefreshPausedAction, (state, action) => {
    state.refreshPaused = action.payload;
  }).addCase(_actions.setRefreshIntervalAction, (state, action) => {
    state.refreshInterval = action.payload;
  });
});
exports.uiReducer = uiReducer;