"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchAlertConnectorsEffect = fetchAlertConnectorsEffect;
exports.fetchDynamicSettingsEffect = fetchDynamicSettingsEffect;
exports.fetchLocationMonitorsEffect = fetchLocationMonitorsEffect;
exports.setDynamicSettingsEffect = setDynamicSettingsEffect;
exports.syncGlobalParamsEffect = syncGlobalParamsEffect;
var _effects = require("redux-saga/effects");
var _i18n = require("@kbn/i18n");
var _alert_rules = require("../alert_rules");
var _kibana_service = require("../../../../utils/kibana_service");
var _actions = require("./actions");
var _fetch_effect = require("../utils/fetch_effect");
var _api = require("./api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function* syncGlobalParamsEffect() {
  yield (0, _effects.takeLeading)(_actions.syncGlobalParamsAction.get, (0, _fetch_effect.fetchEffectFactory)(_api.syncGlobalParamsAPI, _actions.syncGlobalParamsAction.success, _actions.syncGlobalParamsAction.fail, successMessage, failureMessage));
}
function* fetchLocationMonitorsEffect() {
  yield (0, _effects.takeLeading)(String(_actions.getLocationMonitorsAction.get), (0, _fetch_effect.fetchEffectFactory)(_api.fetchLocationMonitors, _actions.getLocationMonitorsAction.success, _actions.getLocationMonitorsAction.fail));
}
function* fetchDynamicSettingsEffect() {
  yield (0, _effects.takeLeading)(String(_actions.getDynamicSettingsAction.get), (0, _fetch_effect.fetchEffectFactory)(_api.getDynamicSettings, _actions.getDynamicSettingsAction.success, _actions.getDynamicSettingsAction.fail));
}
const successMessage = _i18n.i18n.translate('xpack.synthetics.settings.syncGlobalParams', {
  defaultMessage: 'Successfully applied global params to all monitors'
});
const failureMessage = _i18n.i18n.translate('xpack.synthetics.settings.syncGlobalParams.fail', {
  defaultMessage: 'Failed to apply global params to all monitors'
});
function* setDynamicSettingsEffect() {
  const couldNotSaveSettingsText = _i18n.i18n.translate('xpack.synthetics.settings.error.couldNotSave', {
    defaultMessage: 'Could not save settings!'
  });
  yield (0, _effects.takeLatest)(String(_actions.setDynamicSettingsAction.get), function* (action) {
    try {
      yield (0, _effects.call)(_api.setDynamicSettings, {
        settings: action.payload
      });
      yield (0, _effects.put)(_alert_rules.updateDefaultAlertingAction.get());
      yield (0, _effects.put)(_actions.setDynamicSettingsAction.success(action.payload));
      _kibana_service.kibanaService.core.notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.synthetics.settings.saveSuccess', {
        defaultMessage: 'Settings saved!'
      }));
    } catch (err) {
      _kibana_service.kibanaService.core.notifications.toasts.addError(err, {
        title: couldNotSaveSettingsText
      });
      yield (0, _effects.put)(_actions.setDynamicSettingsAction.fail(err));
    }
  });
}
function* fetchAlertConnectorsEffect() {
  yield (0, _effects.takeLeading)(String(_actions.getConnectorsAction.get), (0, _fetch_effect.fetchEffectFactory)(_api.fetchConnectors, _actions.getConnectorsAction.success, _actions.getConnectorsAction.fail));
}