"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSyntheticsRefreshContext = exports.SyntheticsRefreshContextProvider = exports.SyntheticsRefreshContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactUse = require("react-use");
var _moment = _interopRequireDefault(require("moment"));
var _state = require("../state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultContext = {
  lastRefresh: 0,
  refreshApp: () => {
    throw new Error('App refresh was not initialized, set it when you invoke the context');
  }
};
const SyntheticsRefreshContext = /*#__PURE__*/(0, _react.createContext)(defaultContext);
exports.SyntheticsRefreshContext = SyntheticsRefreshContext;
const SyntheticsRefreshContextProvider = ({
  children
}) => {
  const [lastRefresh, setLastRefresh] = (0, _react.useState)(Date.now());
  const refreshPaused = (0, _reactRedux.useSelector)(_state.selectRefreshPaused);
  const refreshInterval = (0, _reactRedux.useSelector)(_state.selectRefreshInterval);
  const refreshApp = (0, _react.useCallback)(() => {
    const refreshTime = Date.now();
    setLastRefresh(refreshTime);
  }, [setLastRefresh]);
  (0, _react.useEffect)(() => {
    if (!refreshPaused) {
      refreshApp();
    }
  }, [refreshApp, refreshPaused]);
  const value = (0, _react.useMemo)(() => {
    return {
      lastRefresh,
      refreshApp
    };
  }, [lastRefresh, refreshApp]);
  (0, _reactUse.useEvent)('visibilitychange', () => {
    const isOutdated = (0, _moment.default)().diff(new Date(lastRefresh), 'seconds') > refreshInterval;
    if (document.visibilityState !== 'hidden' && !refreshPaused && isOutdated) {
      refreshApp();
    }
  }, document);
  (0, _react.useEffect)(() => {
    if (refreshPaused) {
      return;
    }
    const interval = setInterval(() => {
      if (document.visibilityState !== 'hidden') {
        refreshApp();
      }
    }, refreshInterval * 1000);
    return () => clearInterval(interval);
  }, [refreshPaused, refreshApp, refreshInterval]);
  return /*#__PURE__*/_react.default.createElement(SyntheticsRefreshContext.Provider, {
    value: value,
    children: children
  });
};
exports.SyntheticsRefreshContextProvider = SyntheticsRefreshContextProvider;
const useSyntheticsRefreshContext = () => (0, _react.useContext)(SyntheticsRefreshContext);
exports.useSyntheticsRefreshContext = useSyntheticsRefreshContext;