"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FAILED_TO_RUN = exports.ERROR_RUNNING_TEST = exports.BrowserTestRunResult = void 0;
var React = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _browser_test_results = require("../manual_test_run_mode/browser_test_results");
var _browser_steps_list = require("../../common/monitor_test_result/browser_steps_list");
var _use_browser_run_once_monitors = require("../hooks/use_browser_run_once_monitors");
var _test_result_header = require("../test_result_header");
var _stderr_logs = require("../../common/components/stderr_logs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BrowserTestRunResult = ({
  expectPings,
  onDone,
  testRunId
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    retriesExceeded,
    summariesLoading,
    expectedSummariesLoaded,
    stepLoadingInProgress,
    checkGroupResults
  } = (0, _use_browser_run_once_monitors.useBrowserRunOnceMonitors)({
    testRunId,
    expectSummaryDocs: expectPings
  });
  (0, React.useEffect)(() => {
    if (expectedSummariesLoaded) {
      onDone(testRunId);
    }
  }, [onDone, expectedSummariesLoaded, testRunId]);
  if (retriesExceeded) {
    return /*#__PURE__*/React.createElement(_eui.EuiCallOut, {
      title: _browser_test_results.FAILED_TO_SCHEDULE,
      color: "danger",
      iconType: "alert"
    });
  }
  return /*#__PURE__*/React.createElement(React.Fragment, null, checkGroupResults.map(checkGroupResult => {
    var _summaryDoc$monitor, _summaryDoc$error$mes, _summaryDoc$error, _summaryDoc$error2, _summaryDoc$error2$me;
    const {
      checkGroupId,
      journeyStarted,
      summaryDoc,
      stepsLoading,
      steps,
      completedSteps
    } = checkGroupResult;
    const isStepsLoading = !summariesLoading && journeyStarted && summaryDoc && stepsLoading;
    const isStepsLoadingFailed = summaryDoc && !summariesLoading && !stepLoadingInProgress && steps.length === 0;
    const isDownMonitor = (summaryDoc === null || summaryDoc === void 0 ? void 0 : (_summaryDoc$monitor = summaryDoc.monitor) === null || _summaryDoc$monitor === void 0 ? void 0 : _summaryDoc$monitor.status) === 'down';
    return /*#__PURE__*/React.createElement(AccordionWrapper, {
      key: 'accordion-' + checkGroupId,
      id: 'accordion-' + checkGroupId,
      element: "fieldset",
      borders: "horizontal",
      buttonProps: {
        paddingSize: 'm'
      },
      buttonContent: getButtonContent(checkGroupResult),
      paddingSize: "s",
      "data-test-subj": "expandResults",
      initialIsOpen: checkGroupResults.length === 1
    }, isStepsLoading && /*#__PURE__*/React.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs"
    }, /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/React.createElement(_eui.EuiText, null, LOADING_STEPS)), /*#__PURE__*/React.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/React.createElement(_eui.EuiLoadingSpinner, {
      size: "s"
    }))), (isStepsLoadingFailed || isDownMonitor) && /*#__PURE__*/React.createElement(_eui.EuiCallOut, {
      "data-test-subj": "monitorTestRunErrorCallout",
      style: {
        marginTop: euiTheme.base,
        marginBottom: euiTheme.base,
        borderRadius: euiTheme.border.radius.medium,
        fontWeight: euiTheme.font.weight.semiBold
      },
      title: ERROR_RUNNING_TEST,
      size: "s",
      color: "danger",
      iconType: "warning"
    }, /*#__PURE__*/React.createElement(_eui.EuiText, {
      color: "danger"
    }, (_summaryDoc$error$mes = summaryDoc === null || summaryDoc === void 0 ? void 0 : (_summaryDoc$error = summaryDoc.error) === null || _summaryDoc$error === void 0 ? void 0 : _summaryDoc$error.message) !== null && _summaryDoc$error$mes !== void 0 ? _summaryDoc$error$mes : FAILED_TO_RUN)), (isStepsLoadingFailed || isDownMonitor) && (summaryDoc === null || summaryDoc === void 0 ? void 0 : (_summaryDoc$error2 = summaryDoc.error) === null || _summaryDoc$error2 === void 0 ? void 0 : (_summaryDoc$error2$me = _summaryDoc$error2.message) === null || _summaryDoc$error2$me === void 0 ? void 0 : _summaryDoc$error2$me.includes('journey did not finish executing')) && /*#__PURE__*/React.createElement(_stderr_logs.StdErrorLogs, {
      checkGroup: summaryDoc.monitor.check_group,
      hideTitle: completedSteps === 0,
      pageSize: completedSteps === 0 ? 5 : 2
    }), completedSteps > 0 && /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(_eui.EuiTitle, {
      size: "xxxs"
    }, /*#__PURE__*/React.createElement("h3", null, STEPS_LABEL)), /*#__PURE__*/React.createElement(_browser_steps_list.BrowserStepsList, {
      steps: steps,
      loading: Boolean(stepLoadingInProgress),
      error: undefined,
      showStepNumber: true,
      compressed: true,
      testNowMode: true,
      showLastSuccessful: false
    })));
  }));
};
exports.BrowserTestRunResult = BrowserTestRunResult;
const AccordionWrapper = (0, _styledComponents.default)(_eui.EuiAccordion)`
  .euiAccordion__buttonContent {
    width: 100%;
  }
`;
function getButtonContent({
  journeyDoc,
  summaryDoc,
  checkGroupId,
  journeyStarted,
  completedSteps
}) {
  var _journeyDoc$observer, _journeyDoc$observer$;
  return /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(_test_result_header.TestResultHeader, {
    title: journeyDoc === null || journeyDoc === void 0 ? void 0 : (_journeyDoc$observer = journeyDoc.observer) === null || _journeyDoc$observer === void 0 ? void 0 : (_journeyDoc$observer$ = _journeyDoc$observer.geo) === null || _journeyDoc$observer$ === void 0 ? void 0 : _journeyDoc$observer$.name,
    summaryDocs: summaryDoc ? [summaryDoc] : [],
    checkGroupId: checkGroupId,
    journeyStarted: journeyStarted,
    isCompleted: Boolean(summaryDoc),
    configId: journeyDoc === null || journeyDoc === void 0 ? void 0 : journeyDoc.config_id
  }), /*#__PURE__*/React.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(_eui.EuiText, {
    color: "subdued"
  }, _i18n.i18n.translate('xpack.synthetics.monitorManagement.stepCompleted', {
    defaultMessage: '{stepCount, number} {stepCount, plural, one {step} other {steps}}  completed',
    values: {
      stepCount: completedSteps !== null && completedSteps !== void 0 ? completedSteps : 0
    }
  })))));
}
const FAILED_TO_RUN = _i18n.i18n.translate('xpack.synthetics.monitorManagement.failedRun', {
  defaultMessage: 'Failed to run steps'
});
exports.FAILED_TO_RUN = FAILED_TO_RUN;
const ERROR_RUNNING_TEST = _i18n.i18n.translate('xpack.synthetics.testRun.testErrorLabel', {
  defaultMessage: 'Error running test'
});
exports.ERROR_RUNNING_TEST = ERROR_RUNNING_TEST;
const LOADING_STEPS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.loadingSteps', {
  defaultMessage: 'Loading steps...'
});
const STEPS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.steps', {
  defaultMessage: 'Steps'
});