"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallFlyout = exports.RESPONSE_HEADERS = exports.REQUEST_HEADERS = exports.DETAILS = exports.CERTIFICATES = void 0;
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _waterfall_flyout_table = require("./waterfall_flyout_table");
var _middle_truncated_text = require("../middle_truncated_text");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DETAILS = _i18n.i18n.translate('xpack.synthetics.synthetics.waterfall.flyout.details', {
  defaultMessage: 'Details'
});
exports.DETAILS = DETAILS;
const CERTIFICATES = _i18n.i18n.translate('xpack.synthetics.synthetics.waterfall.flyout.certificates', {
  defaultMessage: 'Certificate headers'
});
exports.CERTIFICATES = CERTIFICATES;
const REQUEST_HEADERS = _i18n.i18n.translate('xpack.synthetics.synthetics.waterfall.flyout.requestHeaders', {
  defaultMessage: 'Request headers'
});
exports.REQUEST_HEADERS = REQUEST_HEADERS;
const RESPONSE_HEADERS = _i18n.i18n.translate('xpack.synthetics.synthetics.waterfall.flyout.responseHeaders', {
  defaultMessage: 'Response headers'
});
exports.RESPONSE_HEADERS = RESPONSE_HEADERS;
const FlyoutContainer = (0, _common.euiStyled)(_eui.EuiFlyout)`
  z-index: ${props => props.theme.eui.euiZLevel5};
`;
const WaterfallFlyout = ({
  flyoutData,
  isFlyoutVisible,
  onFlyoutClose
}) => {
  const flyoutRef = (0, _react.useRef)(null);
  const trackMetric = (0, _public.useUiTracker)({
    app: 'uptime'
  });
  (0, _react.useEffect)(() => {
    if (isFlyoutVisible && flyoutData && flyoutRef.current) {
      var _flyoutRef$current;
      (_flyoutRef$current = flyoutRef.current) === null || _flyoutRef$current === void 0 ? void 0 : _flyoutRef$current.focus();
    }
  }, [flyoutData, isFlyoutVisible, flyoutRef]);
  if (!flyoutData || !isFlyoutVisible) {
    return null;
  }
  const {
    x,
    url,
    details,
    certificates,
    requestHeaders,
    responseHeaders
  } = flyoutData;
  trackMetric({
    metric: 'waterfall_flyout',
    metricType: _public.METRIC_TYPE.CLICK
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    tabIndex: -1,
    ref: flyoutRef,
    "data-test-subj": "waterfallFlyout",
    "aria-labelledby": "flyoutTitle"
  }, /*#__PURE__*/_react.default.createElement(FlyoutContainer, {
    size: "s",
    onClose: onFlyoutClose
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "flyoutTitle"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_middle_truncated_text.MiddleTruncatedText, {
    index: x + 1,
    text: url,
    url: url,
    ariaLabel: url,
    highestIndex: x + 1
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_waterfall_flyout_table.Table, {
    rows: details,
    title: DETAILS
  }), !!requestHeaders && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_waterfall_flyout_table.Table, {
    rows: requestHeaders,
    title: REQUEST_HEADERS
  })), !!responseHeaders && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_waterfall_flyout_table.Table, {
    rows: responseHeaders,
    title: RESPONSE_HEADERS
  })), !!certificates && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_waterfall_flyout_table.Table, {
    rows: certificates,
    title: CERTIFICATES
  })))));
};
exports.WaterfallFlyout = WaterfallFlyout;