"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useObjectMetrics = exports.getWeightDeltaPercent = exports.getDeltaPercent = exports.formatBytes = void 0;
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _use_prev_object_metrics = require("./use_prev_object_metrics");
var _types = require("../common/network_data/types");
var _selectors = require("../../../state/network_events/selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useObjectMetrics = () => {
  var _networkEvents2, _networkEvents$loadin;
  const {
    checkGroupId,
    stepIndex
  } = (0, _reactRouterDom.useParams)();
  const {
    mimeData: prevMimeData
  } = (0, _use_prev_object_metrics.usePreviousObjectMetrics)();
  const _networkEvents = (0, _reactRedux.useSelector)(_selectors.networkEventsSelector);
  const networkEvents = (_networkEvents2 = _networkEvents[checkGroupId !== null && checkGroupId !== void 0 ? checkGroupId : '']) === null || _networkEvents2 === void 0 ? void 0 : _networkEvents2[Number(stepIndex)];
  const objectTypeCounts = {};
  const objectTypeWeights = {};
  networkEvents === null || networkEvents === void 0 ? void 0 : networkEvents.events.forEach(event => {
    if (event.mimeType) {
      var _MimeTypesMap$event$m;
      const mimeType = (_MimeTypesMap$event$m = _types.MimeTypesMap[event.mimeType]) !== null && _MimeTypesMap$event$m !== void 0 ? _MimeTypesMap$event$m : _types.MimeType.Other;
      if (objectTypeCounts[mimeType]) {
        objectTypeCounts[mimeType].value++;
      } else {
        objectTypeCounts[mimeType] = {
          value: 1,
          prevValue: 0
        };
      }
      if (objectTypeWeights[mimeType]) {
        objectTypeWeights[mimeType].value += event.transferSize || 0;
      } else {
        objectTypeWeights[mimeType] = {
          value: event.transferSize || 0,
          prevValue: 0
        };
      }
    }
  });
  const totalObjects = Object.values(objectTypeCounts).reduce((acc, val) => acc + val.value, 0);
  const totalObjectsWeight = Object.values(objectTypeWeights).reduce((acc, val) => acc + val.value, 0);
  Object.keys(prevMimeData).forEach(mimeType => {
    var _MimeTypesMap$mimeTyp;
    const mimeTypeKey = (_MimeTypesMap$mimeTyp = _types.MimeTypesMap[mimeType]) !== null && _MimeTypesMap$mimeTyp !== void 0 ? _MimeTypesMap$mimeTyp : _types.MimeType.Other;
    if (objectTypeCounts[mimeTypeKey]) {
      objectTypeCounts[mimeTypeKey].prevValue += prevMimeData[mimeType].count;
    }
    if (objectTypeWeights[mimeTypeKey]) {
      objectTypeWeights[mimeTypeKey].prevValue += prevMimeData[mimeType].weight;
    }
  });
  return {
    loading: (_networkEvents$loadin = networkEvents === null || networkEvents === void 0 ? void 0 : networkEvents.loading) !== null && _networkEvents$loadin !== void 0 ? _networkEvents$loadin : true,
    totalObjects,
    totalObjectsWeight: formatBytes(totalObjectsWeight),
    items: _types.MIME_FILTERS.map(({
      label,
      mimeType
    }) => {
      var _objectTypeCounts$mim, _objectTypeCounts$mim2, _objectTypeCounts$mim3, _objectTypeCounts$mim4, _objectTypeWeights$mi, _objectTypeWeights$mi2, _objectTypeWeights$mi3, _objectTypeWeights$mi4, _objectTypeCounts$mim5, _objectTypeCounts$mim6, _objectTypeCounts$mim7, _objectTypeCounts$mim8, _objectTypeWeights$mi5, _objectTypeWeights$mi6;
      return {
        label,
        mimeType,
        total: totalObjects,
        count: (_objectTypeCounts$mim = objectTypeCounts === null || objectTypeCounts === void 0 ? void 0 : (_objectTypeCounts$mim2 = objectTypeCounts[mimeType]) === null || _objectTypeCounts$mim2 === void 0 ? void 0 : _objectTypeCounts$mim2.value) !== null && _objectTypeCounts$mim !== void 0 ? _objectTypeCounts$mim : 0,
        percent: ((_objectTypeCounts$mim3 = objectTypeCounts === null || objectTypeCounts === void 0 ? void 0 : (_objectTypeCounts$mim4 = objectTypeCounts[mimeType]) === null || _objectTypeCounts$mim4 === void 0 ? void 0 : _objectTypeCounts$mim4.value) !== null && _objectTypeCounts$mim3 !== void 0 ? _objectTypeCounts$mim3 : 0) / totalObjects * 100,
        weight: formatBytes((_objectTypeWeights$mi = (_objectTypeWeights$mi2 = objectTypeWeights[mimeType]) === null || _objectTypeWeights$mi2 === void 0 ? void 0 : _objectTypeWeights$mi2.value) !== null && _objectTypeWeights$mi !== void 0 ? _objectTypeWeights$mi : 0),
        weightPercent: ((_objectTypeWeights$mi3 = (_objectTypeWeights$mi4 = objectTypeWeights[mimeType]) === null || _objectTypeWeights$mi4 === void 0 ? void 0 : _objectTypeWeights$mi4.value) !== null && _objectTypeWeights$mi3 !== void 0 ? _objectTypeWeights$mi3 : 0) / totalObjectsWeight * 100,
        countDelta: getDeltaPercent((_objectTypeCounts$mim5 = objectTypeCounts === null || objectTypeCounts === void 0 ? void 0 : (_objectTypeCounts$mim6 = objectTypeCounts[mimeType]) === null || _objectTypeCounts$mim6 === void 0 ? void 0 : _objectTypeCounts$mim6.value) !== null && _objectTypeCounts$mim5 !== void 0 ? _objectTypeCounts$mim5 : 0, (_objectTypeCounts$mim7 = objectTypeCounts === null || objectTypeCounts === void 0 ? void 0 : (_objectTypeCounts$mim8 = objectTypeCounts[mimeType]) === null || _objectTypeCounts$mim8 === void 0 ? void 0 : _objectTypeCounts$mim8.prevValue) !== null && _objectTypeCounts$mim7 !== void 0 ? _objectTypeCounts$mim7 : 0),
        weightDelta: getWeightDeltaPercent(objectTypeWeights === null || objectTypeWeights === void 0 ? void 0 : (_objectTypeWeights$mi5 = objectTypeWeights[mimeType]) === null || _objectTypeWeights$mi5 === void 0 ? void 0 : _objectTypeWeights$mi5.value, objectTypeWeights === null || objectTypeWeights === void 0 ? void 0 : (_objectTypeWeights$mi6 = objectTypeWeights[mimeType]) === null || _objectTypeWeights$mi6 === void 0 ? void 0 : _objectTypeWeights$mi6.prevValue)
      };
    })
  };
};
exports.useObjectMetrics = useObjectMetrics;
const getWeightDeltaPercent = (current, previous) => {
  if (previous === 0 || !previous) {
    return 0;
  }
  return ((current - previous) / previous * 100).toFixed(0);
};
exports.getWeightDeltaPercent = getWeightDeltaPercent;
const getDeltaPercent = (current, previous) => {
  if (previous === 0) {
    return 0;
  }
  return ((current - previous) / previous * 100).toFixed(0);
};
exports.getDeltaPercent = getDeltaPercent;
const formatBytes = (bytes, decimals = 0) => {
  if (bytes === 0) return '0 Bytes';
  const k = 1024;
  const dm = decimals < 0 ? 0 : decimals;
  const sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];
  const i = Math.floor(Math.log(bytes) / Math.log(k));
  return parseFloat((bytes / Math.pow(k, i)).toFixed(dm)) + ' ' + sizes[i];
};
exports.formatBytes = formatBytes;