"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSettingsPageHeader = void 0;
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSettingsPageHeader = (history, syntheticsPath) => {
  // Not a component, but it doesn't matter. Hooks are just functions
  const match = (0, _reactRouterDom.useRouteMatch)(_constants.SYNTHETICS_SETTINGS_ROUTE); // eslint-disable-line react-hooks/rules-of-hooks

  if (!match) {
    return {};
  }
  const {
    tabId
  } = match.params;
  const replaceTab = newTabId => {
    return `${syntheticsPath}${_constants.SYNTHETICS_SETTINGS_ROUTE.replace(':tabId', newTabId)}`;
  };
  return {
    pageTitle: _i18n.i18n.translate('xpack.synthetics.settingsRoute.pageHeaderTitle', {
      defaultMessage: 'Settings'
    }),
    rightSideItems: [],
    tabs: [{
      label: _i18n.i18n.translate('xpack.synthetics.settingsTabs.alerting', {
        defaultMessage: 'Alerting'
      }),
      isSelected: tabId === 'alerting',
      href: replaceTab('alerting')
    }, {
      label: _i18n.i18n.translate('xpack.synthetics.settingsTabs.privateLocations', {
        defaultMessage: 'Private Locations'
      }),
      isSelected: tabId === 'private-locations',
      href: replaceTab('private-locations')
    }, {
      label: _i18n.i18n.translate('xpack.synthetics.settingsTabs.params', {
        defaultMessage: 'Global Parameters'
      }),
      isSelected: tabId === 'params' || !tabId,
      href: replaceTab('params')
    }, {
      label: _i18n.i18n.translate('xpack.synthetics.settingsTabs.dataRetention', {
        defaultMessage: 'Data Retention'
      }),
      isSelected: tabId === 'data-retention',
      href: replaceTab('data-retention')
    }, {
      label: _i18n.i18n.translate('xpack.synthetics.settingsTabs.apiKeys', {
        defaultMessage: 'Project API Keys'
      }),
      isSelected: tabId === 'api-keys',
      href: replaceTab('api-keys')
    }]
  };
};
exports.getSettingsPageHeader = getSettingsPageHeader;