"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotFound = NotFound;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NOT_FOUND_TITLE = _i18n.i18n.translate('xpack.synthetics.notFoundTitle', {
  defaultMessage: 'Page not found'
});
const NOT_FOUND_BODY = _i18n.i18n.translate('xpack.synthetics.notFoundBody', {
  defaultMessage: "Sorry, we can't find the page you're looking for. It might have been removed or renamed, or maybe it never existed."
});

/**
 * Renders a "Page not found" error.
 *
 * @deprecated This component must be moved to Kibana/Shared UX. It was created
 * as a temporary solution to move #144366 forward but it should not be used.
 */
function NotFound() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    layout: "vertical",
    color: "subdued",
    titleSize: "m",
    iconType: "questionInCircle",
    iconColor: "primary",
    title: /*#__PURE__*/_react.default.createElement("h2", null, NOT_FOUND_TITLE),
    body: /*#__PURE__*/_react.default.createElement("p", null, NOT_FOUND_BODY)
  });
}