"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupFields = exports.GROUP_TITLE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _hooks = require("../../../../../hooks");
var _group_menu = require("./group_menu");
var _runtime_types = require("../../../../../../../../common/runtime_types");
var _overview = require("../../../../../state/overview");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GroupFields = () => {
  const {
    groupBy: {
      field: groupField,
      order: groupOrder
    }
  } = (0, _reactRedux.useSelector)(_overview.selectOverviewState);
  const dispatch = (0, _reactRedux.useDispatch)();
  const [urlParams, updateUrlParams] = (0, _hooks.useUrlParams)();
  const {
    groupBy: urlGroupField,
    groupOrderBy: urlGroupOrderBy
  } = urlParams();
  const isUrlHydratedFromRedux = (0, _react.useRef)(false);
  (0, _react.useEffect)(() => {
    if (urlGroupField !== groupField) {
      if (!urlGroupField && groupField !== 'none' && !isUrlHydratedFromRedux.current) {
        // Hydrate url only during initialization
        updateUrlParams({
          groupBy: groupField,
          groupOrderBy: groupOrder
        });
      } else {
        dispatch((0, _overview.setOverviewGroupByAction)({
          field: urlGroupField !== null && urlGroupField !== void 0 ? urlGroupField : 'none',
          order: urlGroupOrderBy !== null && urlGroupOrderBy !== void 0 ? urlGroupOrderBy : 'asc'
        }));
      }
    }
    isUrlHydratedFromRedux.current = true;

    // Only depend on the serialized snapshot
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [dispatch, groupField, groupOrder, urlGroupField, urlGroupOrderBy]);
  const handleChange = groupByState => {
    dispatch((0, _overview.setOverviewGroupByAction)(groupByState));
    updateUrlParams({
      groupBy: groupByState.field,
      groupOrderBy: groupByState.order
    });
  };
  const groupByOptions = [{
    label: NONE_LABEL,
    value: 'none',
    checked: groupField === 'none',
    defaultSortOrder: 'asc',
    onClick: () => {
      handleChange({
        field: 'none',
        order: groupOrder
      });
    }
  }, {
    label: LOCATION_LABEL,
    value: 'location.id',
    checked: groupField === 'locationId',
    defaultSortOrder: 'asc',
    onClick: () => {
      handleChange({
        field: 'locationId',
        order: groupOrder
      });
    }
  }, {
    label: MONITOR_TYPE_LABEL,
    value: _runtime_types.ConfigKey.MONITOR_TYPE,
    checked: groupField === _runtime_types.ConfigKey.MONITOR_TYPE,
    defaultSortOrder: 'desc',
    onClick: () => {
      handleChange({
        field: _runtime_types.ConfigKey.MONITOR_TYPE,
        order: groupOrder
      });
    }
  }, {
    label: TAG_LABEL,
    value: _runtime_types.ConfigKey.TAGS,
    checked: groupField === _runtime_types.ConfigKey.TAGS,
    defaultSortOrder: 'desc',
    onClick: () => {
      handleChange({
        field: _runtime_types.ConfigKey.TAGS,
        order: groupOrder
      });
    }
  }, {
    label: PROJECT_LABEL,
    value: _runtime_types.ConfigKey.PROJECT_ID,
    checked: groupField === _runtime_types.ConfigKey.PROJECT_ID,
    defaultSortOrder: 'desc',
    onClick: () => {
      handleChange({
        field: _runtime_types.ConfigKey.PROJECT_ID,
        order: groupOrder
      });
    }
  }];
  const {
    asc,
    desc,
    label
  } = getOrderContent(groupField);
  const orderByOptions = [{
    label: asc,
    value: 'asc',
    checked: groupOrder === 'asc',
    onClick: () => {
      handleChange({
        field: groupField,
        order: 'asc'
      });
    }
  }, {
    label: desc,
    value: 'desc',
    checked: groupOrder === 'desc',
    onClick: () => {
      handleChange({
        field: groupField,
        order: 'desc'
      });
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "none",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, GROUP_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "syntheticsOverviewGroupButton"
  }, /*#__PURE__*/_react.default.createElement(_group_menu.GroupMenu, {
    groupOptions: groupByOptions,
    orderByOptions: orderByOptions,
    groupField: label
  })))));
};
exports.GroupFields = GroupFields;
const getOrderContent = groupField => {
  switch (groupField) {
    case 'locationId':
      return {
        asc: SORT_ALPHABETICAL_ASC,
        desc: SORT_ALPHABETICAL_DESC,
        label: LOCATION_LABEL
      };
    case _runtime_types.ConfigKey.MONITOR_TYPE:
      return {
        asc: SORT_ALPHABETICAL_ASC,
        desc: SORT_ALPHABETICAL_DESC,
        label: MONITOR_TYPE_LABEL
      };
    case _runtime_types.ConfigKey.TAGS:
      return {
        asc: SORT_ALPHABETICAL_ASC,
        desc: SORT_ALPHABETICAL_DESC,
        label: TAG_LABEL
      };
    case _runtime_types.ConfigKey.PROJECT_ID:
      return {
        asc: SORT_ALPHABETICAL_ASC,
        desc: SORT_ALPHABETICAL_DESC,
        label: PROJECT_LABEL
      };
    default:
      return {
        asc: ASCENDING_LABEL,
        desc: DESCENDING_LABEL,
        label: NONE_LABEL
      };
  }
};
const GROUP_TITLE = _i18n.i18n.translate('xpack.synthetics.overview.groupPopover.group.title', {
  defaultMessage: 'Group by'
});
exports.GROUP_TITLE = GROUP_TITLE;
const SORT_ALPHABETICAL_ASC = _i18n.i18n.translate('xpack.synthetics.overview.groupPopover.alphabetical.asc', {
  defaultMessage: 'A -> Z',
  description: 'Describes ascending alphabetical sort order'
});
const SORT_ALPHABETICAL_DESC = _i18n.i18n.translate('xpack.synthetics.overview.groupPopover.alphabetical.desc', {
  defaultMessage: 'Z -> A',
  description: 'Describes descending alphabetical sort order'
});
const ASCENDING_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.groupPopover.ascending.label', {
  defaultMessage: 'Ascending'
});
const DESCENDING_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.groupPopover.descending.label', {
  defaultMessage: 'Descending'
});
const NONE_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.groupPopover.none.label', {
  defaultMessage: 'None'
});
const LOCATION_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.groupPopover.location.label', {
  defaultMessage: 'Location'
});
const MONITOR_TYPE_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.groupPopover.monitorType.label', {
  defaultMessage: 'Monitor type'
});
const TAG_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.groupPopover.tag.label', {
  defaultMessage: 'Tag'
});
const PROJECT_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.groupPopover.project.label', {
  defaultMessage: 'Project'
});