"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorAsyncError = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _state = require("../../../../state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorAsyncError = () => {
  const [isDismissed, setIsDismissed] = (0, _react.useState)(false);
  const {
    data: {
      syncErrors
    }
  } = (0, _reactRedux.useSelector)(_state.selectMonitorListState);
  const {
    locations
  } = (0, _reactRedux.useSelector)(_state.selectServiceLocationsState);
  return syncErrors && syncErrors.length > 0 && !isDismissed ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.monitorManagement.monitorSync.failure.title",
      defaultMessage: "Some monitors are not running correctly"
    }),
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.monitorManagement.monitorSync.failure.content",
    defaultMessage: "There was a problem running your monitors for one or more locations:"
  })), /*#__PURE__*/_react.default.createElement("ul", null, Object.values(syncErrors !== null && syncErrors !== void 0 ? syncErrors : {}).map(e => {
    var _locations$find, _e$error$status, _e$error, _e$error$reason, _e$error2;
    return /*#__PURE__*/_react.default.createElement("li", {
      key: e.locationId
    }, `${(_locations$find = locations.find(location => location.id === e.locationId)) === null || _locations$find === void 0 ? void 0 : _locations$find.label} - ${STATUS_LABEL}: ${(_e$error$status = (_e$error = e.error) === null || _e$error === void 0 ? void 0 : _e$error.status) !== null && _e$error$status !== void 0 ? _e$error$status : NOT_AVAILABLE_LABEL}; ${REASON_LABEL}: ${(_e$error$reason = (_e$error2 = e.error) === null || _e$error2 === void 0 ? void 0 : _e$error2.reason) !== null && _e$error$reason !== void 0 ? _e$error$reason : NOT_AVAILABLE_LABEL}`);
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "syntheticsMonitorAsyncErrorButton",
    onClick: () => setIsDismissed(true),
    color: "warning"
  }, DISMISS_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })) : null;
};
exports.MonitorAsyncError = MonitorAsyncError;
const REASON_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.monitorSync.failure.reasonLabel', {
  defaultMessage: 'Reason'
});
const STATUS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.monitorSync.failure.statusLabel', {
  defaultMessage: 'Status'
});
const NOT_AVAILABLE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.monitorSync.failure.notAvailable', {
  defaultMessage: 'Not available'
});
const DISMISS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.monitorSync.failure.dismissLabel', {
  defaultMessage: 'Dismiss'
});