"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateMonitorButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _use_capabilities = require("../../../../hooks/use_capabilities");
var _permissions = require("../common/components/permissions");
var _hooks = require("../../hooks");
var _constants = require("../../../../../common/constants");
var _synthetics_settings_context = require("../../contexts/synthetics_settings_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateMonitorButton = () => {
  const {
    basePath
  } = (0, _react.useContext)(_synthetics_settings_context.SyntheticsSettingsContext);
  const {
    enablement: {
      isEnabled
    }
  } = (0, _hooks.useEnablement)();
  const canEditSynthetics = (0, _use_capabilities.useCanEditSynthetics)();
  return /*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
    canEditSynthetics: canEditSynthetics
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    iconSide: "left",
    iconType: "plusInCircleFilled",
    href: `${basePath}/app/synthetics${_constants.MONITOR_ADD_ROUTE}`,
    isDisabled: !isEnabled || !canEditSynthetics,
    "data-test-subj": "syntheticsAddMonitorBtn"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.monitors.pageHeader.createButton.label",
    defaultMessage: "Create Monitor"
  })));
};
exports.CreateMonitorButton = CreateMonitorButton;