"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThrottlingLatencyField = exports.LATENCY_NEGATIVE_ERROR = exports.LATENCY_LABEL = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _runtime_types = require("../../../../../../../common/runtime_types");
var _optional_label = require("../optional_label");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ThrottlingLatencyField = ({
  throttling,
  readOnly,
  onFieldBlur,
  validate,
  handleInputChange,
  throttlingValue
}) => {
  var _validate$ConfigKey$T;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: LATENCY_LABEL,
    labelAppend: /*#__PURE__*/_react.default.createElement(_optional_label.OptionalLabel, null),
    isInvalid: validate ? !!(validate !== null && validate !== void 0 && (_validate$ConfigKey$T = validate[_runtime_types.ConfigKey.THROTTLING_CONFIG]) !== null && _validate$ConfigKey$T !== void 0 && _validate$ConfigKey$T.call(validate, throttling)) : false,
    error: LATENCY_NEGATIVE_ERROR
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    min: 0,
    value: throttlingValue.latency,
    onChange: event => handleInputChange(event.target.value),
    onBlur: () => onFieldBlur === null || onFieldBlur === void 0 ? void 0 : onFieldBlur('latency'),
    "data-test-subj": "syntheticsBrowserLatency",
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("strong", null, "ms")),
    readOnly: readOnly
  }));
};
exports.ThrottlingLatencyField = ThrottlingLatencyField;
const LATENCY_LABEL = _i18n.i18n.translate('xpack.synthetics.createPackagePolicy.stepConfigure.browserAdvancedSettings.throttling.latency.label', {
  defaultMessage: 'Latency'
});
exports.LATENCY_LABEL = LATENCY_LABEL;
const LATENCY_NEGATIVE_ERROR = _i18n.i18n.translate('xpack.synthetics.createPackagePolicy.stepConfigure.browserAdvancedSettings.throttling.latency.error', {
  defaultMessage: 'Latency must not be negative.'
});
exports.LATENCY_NEGATIVE_ERROR = LATENCY_NEGATIVE_ERROR;