"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScreenshotImage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _empty_thumbnail = require("./empty_thumbnail");
var _screenshot_size = require("./screenshot_size");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_SIZE = [512, 512];
const ScreenshotImage = ({
  label,
  imgSrc,
  isLoading,
  animateLoading = true,
  unavailableMessage,
  borderColor,
  borderRadius,
  hasBorder = true,
  size = [100, 64],
  onMouseEnter,
  onMouseLeave,
  onClick
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [naturalSize, setNaturalSize] = (0, _react.useState)(DEFAULT_SIZE);
  const {
    width,
    height
  } = (0, _screenshot_size.getConfinedScreenshotSize)(size, naturalSize);
  return imgSrc ?
  /*#__PURE__*/
  // eslint-disable-next-line jsx-a11y/no-noninteractive-element-interactions
  _react.default.createElement("img", {
    css: {
      outline: 0,
      objectFit: 'contain',
      width,
      height,
      cursor: 'pointer',
      border: euiTheme.border.thin,
      ...(borderColor ? {
        borderColor
      } : {}),
      ...(borderRadius ? {
        borderRadius
      } : {}),
      ...(!hasBorder ? {
        borderRadius
      } : {}),
      ...(borderColor ? {
        borderColor
      } : {})
    },
    src: imgSrc,
    alt: label,
    "data-test-subj": "stepScreenshotThumbnail",
    onLoad: evt => {
      var _naturalWidth, _evt$target, _naturalHeight, _evt$target2;
      const updatedSize = [(_naturalWidth = evt === null || evt === void 0 ? void 0 : (_evt$target = evt.target) === null || _evt$target === void 0 ? void 0 : _evt$target.naturalWidth) !== null && _naturalWidth !== void 0 ? _naturalWidth : naturalSize[0], (_naturalHeight = evt === null || evt === void 0 ? void 0 : (_evt$target2 = evt.target) === null || _evt$target2 === void 0 ? void 0 : _evt$target2.naturalHeight) !== null && _naturalHeight !== void 0 ? _naturalHeight : naturalSize[1]];
      setNaturalSize(updatedSize);
    },
    onMouseEnter: onMouseEnter,
    onMouseLeave: onMouseLeave,
    onClick: onClick,
    onKeyDown: undefined
  }) : /*#__PURE__*/_react.default.createElement(_empty_thumbnail.EmptyThumbnail, {
    isLoading: isLoading,
    size: size === 'full' ? naturalSize : size,
    unavailableMessage: unavailableMessage,
    borderRadius: borderRadius,
    animateLoading: animateLoading
  });
};
exports.ScreenshotImage = ScreenshotImage;