"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewDocument = exports.INSPECT_DOCUMENT = void 0;
var _eui = require("@elastic/eui");
var _public = require("@kbn/unified-doc-viewer-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _use_date_format = require("../../../../../hooks/use_date_format");
var _monitor_detail_flyout = require("../../monitors_page/overview/overview/monitor_detail_flyout");
var _synthetics_data_view_context = require("../../../contexts/synthetics_data_view_context");
var _constants = require("../../../../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ViewDocument = ({
  ping
}) => {
  const [isFlyoutVisible, setIsFlyoutVisible] = (0, _react.useState)(false);
  const dataView = (0, _synthetics_data_view_context.useSyntheticsDataView)();
  const formatter = (0, _use_date_format.useDateFormat)();
  const [, hit] = (0, _public.useEsDocSearch)({
    id: ping.docId,
    index: _constants.SYNTHETICS_INDEX_PATTERN,
    dataView
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "syntheticsViewDocumentButton",
    iconType: "inspect",
    title: INSPECT_DOCUMENT,
    onClick: evt => {
      evt.stopPropagation();
      setIsFlyoutVisible(true);
    }
  }), isFlyoutVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: () => setIsFlyoutVisible(false),
    ownFocus: true,
    onClick: evt => {
      // needed to prevent propagation to the table row click
      evt.stopPropagation();
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h4", null, INDEXED_AT, " ", formatter(ping.timestamp)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, dataView !== null && dataView !== void 0 && dataView.id && hit ? /*#__PURE__*/_react.default.createElement(_public.UnifiedDocViewer, {
    hit: hit,
    dataView: dataView
  }) : /*#__PURE__*/_react.default.createElement(_monitor_detail_flyout.LoadingState, null))));
};
exports.ViewDocument = ViewDocument;
const INDEXED_AT = _i18n.i18n.translate('xpack.synthetics.monitorDetails.summary.indexedAt', {
  defaultMessage: 'Indexed at'
});
const INSPECT_DOCUMENT = _i18n.i18n.translate('xpack.synthetics.monitorDetails.action.inspectDocument', {
  defaultMessage: 'Inspect document'
});
exports.INSPECT_DOCUMENT = INSPECT_DOCUMENT;