"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TagsBadges = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFilterLabel = tag => {
  return _i18n.i18n.translate('xpack.synthetics.tagsList.filter', {
    defaultMessage: 'Click to filter list with tag {tag}',
    values: {
      tag
    }
  });
};
const TagsBadges = ({
  tags,
  onClick
}) => {
  const [toDisplay, setToDisplay] = (0, _react.useState)(3);
  if (!tags || tags.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, "--");
  }
  const tagsToDisplay = tags.slice(0, toDisplay);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "xs",
    style: {
      maxWidth: 400
    },
    alignItems: "baseline"
  }, tagsToDisplay.map(tag =>
  /*#__PURE__*/
  // filtering only makes sense in monitor list, where we have summary
  _react.default.createElement(_eui.EuiFlexItem, {
    key: tag,
    grow: false
  }, onClick ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    key: tag,
    title: getFilterLabel(tag),
    onClick: () => {
      onClick(tag);
    },
    onClickAriaLabel: getFilterLabel(tag),
    color: "hollow",
    className: "eui-textTruncate",
    style: {
      maxWidth: 120
    }
  }, tag) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    key: tag,
    color: "hollow",
    className: "eui-textTruncate",
    style: {
      maxWidth: 120
    }
  }, tag))), tags.length > toDisplay && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: tags.length - toDisplay,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, tags.slice(toDisplay, tags.length).map(tag => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      key: tag,
      size: "s"
    }, tag)))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    onClick: () => {
      setToDisplay(tags.length);
    },
    onClickAriaLabel: EXPAND_TAGS_LABEL
  }, "+", tags.length - toDisplay))), toDisplay > 3 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: tags.length - 3,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: COLLAPSE_TAGS_LABEL,
    key: toDisplay
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    onClick: () => {
      setToDisplay(3);
    },
    onClickAriaLabel: COLLAPSE_TAGS_LABEL
  }, "-", tags.length - 3))));
};
exports.TagsBadges = TagsBadges;
const EXPAND_TAGS_LABEL = _i18n.i18n.translate('xpack.synthetics.management.monitorList.tags.expand', {
  defaultMessage: 'Click to view remaining tags'
});
const COLLAPSE_TAGS_LABEL = _i18n.i18n.translate('xpack.synthetics.management.monitorList.tags.collapse', {
  defaultMessage: 'Click to collapse tags'
});