"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LocationStatusBadges = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_monitor_detail_locator = require("../../../hooks/use_monitor_detail_locator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_DISPLAY_COUNT = 3;
const LocationStatusBadges = ({
  loading,
  locations,
  configId
}) => {
  const [toDisplay, setToDisplay] = (0, _react.useState)(DEFAULT_DISPLAY_COUNT);
  if (loading && !locations) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
  }
  const locationsToDisplay = locations.slice(0, toDisplay);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    css: {
      maxWidth: 450,
      overflow: 'hidden'
    },
    wrap: true,
    responsive: false
  }, locationsToDisplay.map(loc => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: loc.id,
    grow: false,
    css: {
      overflow: 'hidden',
      flexBasis: 'fit-content'
    }
  }, /*#__PURE__*/_react.default.createElement(MonitorDetailLinkForLocation, {
    configId: configId,
    locationId: loc.id,
    locationLabel: loc.label,
    color: loc.color
  }))), locations.length > toDisplay && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: locations.length - toDisplay,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, locations.slice(toDisplay, locations.length).map(loc => /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: loc.color
    }, loc.label)))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    onClick: () => {
      setToDisplay(locations.length);
    },
    onClickAriaLabel: EXPAND_LOCATIONS_LABEL
  }, "+", locations.length - toDisplay))), toDisplay > DEFAULT_DISPLAY_COUNT && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: locations.length - 3,
    grow: false,
    css: {
      overflow: 'hidden'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: COLLAPSE_LOCATIONS_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    onClick: () => {
      setToDisplay(DEFAULT_DISPLAY_COUNT);
    },
    onClickAriaLabel: COLLAPSE_LOCATIONS_LABEL
  }, "-", locations.length - DEFAULT_DISPLAY_COUNT))));
};
exports.LocationStatusBadges = LocationStatusBadges;
const MonitorDetailLinkForLocation = ({
  configId,
  locationId,
  locationLabel,
  color
}) => {
  const monitorDetailLinkUrl = (0, _use_monitor_detail_locator.useMonitorDetailLocator)({
    configId,
    locationId
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    iconType: () => /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "m",
      type: "dot",
      color: color
    }),
    color: "hollow",
    iconOnClickAriaLabel: CLICK_LOCATION_LABEL,
    iconOnClick: () => {
      // Empty
    },
    href: monitorDetailLinkUrl !== null && monitorDetailLinkUrl !== void 0 ? monitorDetailLinkUrl : '/'
  }, locationLabel);
};
const EXPAND_LOCATIONS_LABEL = _i18n.i18n.translate('xpack.synthetics.management.monitorList.locations.expand', {
  defaultMessage: 'Click to view remaining locations'
});
const COLLAPSE_LOCATIONS_LABEL = _i18n.i18n.translate('xpack.synthetics.management.monitorList.locations.collapse', {
  defaultMessage: 'Click to collapse locations'
});
const CLICK_LOCATION_LABEL = _i18n.i18n.translate('xpack.synthetics.management.location.clickMessage', {
  defaultMessage: 'Click to view details for this location.'
});