"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CertMonitors = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _monitor_page_link = require("./monitor_page_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CertMonitors = ({
  monitors
}) => {
  return /*#__PURE__*/_react.default.createElement("span", null, monitors.map((mon, ind) => /*#__PURE__*/_react.default.createElement("span", {
    key: mon.id
  }, ind > 0 && ', ', /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: mon.url
  }, /*#__PURE__*/_react.default.createElement(_monitor_page_link.MonitorPageLink, {
    configId: mon.configId
  }, mon.name || mon.id)))));
};
exports.CertMonitors = CertMonitors;