"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unset = unset;
var _get = require("./get");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Unset a (potentially nested) key from given object.
 * This mutates the original object.
 *
 * @example
 * ```
 * unset(myObj, 'someRootProperty');
 * unset(myObj, 'some.nested.path');
 * ```
 */
function unset(obj, atPath) {
  const paths = atPath.split('.').map(s => s.trim()).filter(v => v !== '');
  if (paths.length === 0) {
    return;
  }
  if (paths.length === 1) {
    delete obj[paths[0]];
    return;
  }
  const property = paths.pop();
  const parent = (0, _get.get)(obj, paths);
  if (parent !== undefined) {
    delete parent[property];
  }
}