"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validSlackApiChannelsRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _axios = _interopRequireDefault(require("axios"));
var _axios_utils = require("@kbn/actions-plugin/server/lib/axios_utils");
var _common = require("../../common");
var _constants = require("../../common/slack_api/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bodySchema = _configSchema.schema.object({
  authToken: _configSchema.schema.string(),
  channelIds: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    minSize: 1,
    maxSize: 25
  })
});
const validSlackApiChannelsRoute = (router, configurationUtilities, logger) => {
  router.post({
    path: `${_common.INTERNAL_BASE_STACK_CONNECTORS_API_PATH}/_slack_api/channels/_valid`,
    validate: {
      body: bodySchema
    }
  }, handler);
  async function handler(ctx, req, res) {
    const {
      authToken,
      channelIds
    } = req.body;
    const axiosInstance = _axios.default.create();
    const validChannelId = (channelId = '') => {
      return (0, _axios_utils.request)({
        axios: axiosInstance,
        configurationUtilities,
        headers: {
          Authorization: `Bearer ${authToken}`,
          'Content-type': 'application/json; charset=UTF-8'
        },
        logger,
        method: 'get',
        url: `${_constants.SLACK_URL}conversations.info?channel=${channelId}`
      });
    };
    const promiseValidChannels = [];
    for (const channelId of channelIds) {
      promiseValidChannels.push(validChannelId(channelId));
    }
    const validChannels = [];
    const invalidChannels = [];
    const resultValidChannels = await Promise.all(promiseValidChannels);
    resultValidChannels.forEach((result, resultIdx) => {
      var _result$data;
      if (result.data.ok && (_result$data = result.data) !== null && _result$data !== void 0 && _result$data.channel) {
        var _result$data2;
        const {
          id,
          name
        } = (_result$data2 = result.data) === null || _result$data2 === void 0 ? void 0 : _result$data2.channel;
        validChannels.push({
          id,
          name
        });
      } else if (result.data.error && channelIds[resultIdx]) {
        invalidChannels.push(channelIds[resultIdx]);
      }
    });
    return res.ok({
      body: {
        validChannels,
        invalidChannels
      }
    });
  }
};
exports.validSlackApiChannelsRoute = validSlackApiChannelsRoute;