"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderParameterTemplates = void 0;
var _lodash = require("lodash");
var _fp = require("@kbn/safer-lodash-set/fp");
var _constants = require("../../../common/sentinelone/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderParameterTemplates = (params, variables) => {
  const context = variables === null || variables === void 0 ? void 0 : variables.context;
  const alertIds = (0, _lodash.map)(context.alerts, '_id');
  if ((params === null || params === void 0 ? void 0 : params.subAction) === _constants.SUB_ACTION.KILL_PROCESS) {
    var _context$alerts$0$hos;
    const processNames = params.subActionParams.processName && [params.subActionParams.processName] || (0, _lodash.map)(context.alerts, 'process.name').filter(elm => elm);
    return {
      subAction: _constants.SUB_ACTION.KILL_PROCESS,
      subActionParams: {
        processName: processNames.join(','),
        computerName: (_context$alerts$0$hos = context.alerts[0].host) === null || _context$alerts$0$hos === void 0 ? void 0 : _context$alerts$0$hos.name,
        alertIds
      }
    };
  }
  if ((params === null || params === void 0 ? void 0 : params.subAction) === _constants.SUB_ACTION.ISOLATE_HOST) {
    var _context$alerts$0$hos2;
    return {
      subAction: _constants.SUB_ACTION.ISOLATE_HOST,
      subActionParams: {
        computerName: (_context$alerts$0$hos2 = context.alerts[0].host) === null || _context$alerts$0$hos2 === void 0 ? void 0 : _context$alerts$0$hos2.name,
        alertIds
      }
    };
  }
  if ((params === null || params === void 0 ? void 0 : params.subAction) === _constants.SUB_ACTION.RELEASE_HOST) {
    var _context$alerts$0$hos3;
    return {
      subAction: _constants.SUB_ACTION.RELEASE_HOST,
      subActionParams: {
        computerName: (_context$alerts$0$hos3 = context.alerts[0].host) === null || _context$alerts$0$hos3 === void 0 ? void 0 : _context$alerts$0$hos3.name,
        alertIds
      }
    };
  }
  if ((params === null || params === void 0 ? void 0 : params.subAction) === _constants.SUB_ACTION.EXECUTE_SCRIPT) {
    var _context$alerts$0$hos4;
    return {
      subAction: _constants.SUB_ACTION.EXECUTE_SCRIPT,
      subActionParams: {
        computerName: (_context$alerts$0$hos4 = context.alerts[0].host) === null || _context$alerts$0$hos4 === void 0 ? void 0 : _context$alerts$0$hos4.name,
        ...params.subActionParams,
        alertIds
      }
    };
  }
  let body;
  try {
    let bodyObject;
    const alerts = context.alerts;
    if (alerts) {
      // Remove the "kibana" entry from all alerts to reduce weight, the same data can be found in other parts of the alert object.
      bodyObject = (0, _fp.set)('context.alerts', alerts.map(({
        kibana,
        ...alert
      }) => alert), variables);
    } else {
      bodyObject = variables;
    }
    body = JSON.stringify(bodyObject);
  } catch (err) {
    body = JSON.stringify({
      error: {
        message: err.message
      }
    });
  }
  return (0, _fp.set)('subActionParams.body', body, params);
};
exports.renderParameterTemplates = renderParameterTemplates;