"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getActionType = getActionType;
var _react = require("react");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const torqDefaultBody = `{
  "alert": {{alert}},
  "context": {{context}},
  "rule": {{rule}},
  "state": {{state}},
  "date": "{{date}}",
  "kibana_base_url": "{{kibanaBaseUrl}}"
}`;
function replaceReferencesWithNumbers(body) {
  return body.replace(/\{\{[.\w]+\}\}/gm, '42');
}
function getActionType() {
  const validateParams = async actionParams => {
    var _actionParams$body;
    const translations = await Promise.resolve().then(() => _interopRequireWildcard(require('./translations')));
    const errors = {
      body: []
    };
    const validationResult = {
      errors
    };
    validationResult.errors = errors;
    if (!((_actionParams$body = actionParams.body) !== null && _actionParams$body !== void 0 && _actionParams$body.length)) {
      errors.body.push(translations.BODY_REQUIRED);
    } else {
      try {
        JSON.parse(replaceReferencesWithNumbers(actionParams.body || ''));
      } catch (e) {
        errors.body.push(translations.INVALID_JSON);
      }
    }
    return validationResult;
  };
  return {
    id: '.torq',
    iconClass: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./logo')))),
    selectMessage: i18n.TORQ_SELECT_MESSAGE,
    actionTypeTitle: i18n.TORQ_ACTION_TYPE_TITLE,
    validateParams,
    actionConnectorFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./torq_connectors')))),
    actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./torq_params')))),
    defaultActionParams: {
      body: torqDefaultBody
    }
  };
}