"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateMappingForConnector = exports.translationMapping = exports.isValidFieldForConnector = exports.isRequiredField = void 0;
var _lodash = require("lodash");
var _types = require("./types");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const casesRequiredFields = ['caseNameConfig', 'descriptionConfig', 'commentsConfig', 'caseIdConfig'];
const casesFields = [...casesRequiredFields];
const alertsRequiredFields = ['ruleNameConfig', 'alertIdConfig'];
const alertsFields = ['severityConfig', 'commentsConfig', ...alertsRequiredFields];
const translationMapping = {
  caseIdConfig: i18n.SW_REQUIRED_CASE_ID,
  alertIdConfig: i18n.SW_REQUIRED_ALERT_ID,
  caseNameConfig: i18n.SW_REQUIRED_CASE_NAME,
  descriptionConfig: i18n.SW_REQUIRED_DESCRIPTION,
  commentsConfig: i18n.SW_REQUIRED_COMMENTS,
  ruleNameConfig: i18n.SW_REQUIRED_RULE_NAME,
  severityConfig: i18n.SW_REQUIRED_SEVERITY
};
exports.translationMapping = translationMapping;
const isValidFieldForConnector = (connectorType, fieldId) => {
  if (connectorType === _types.SwimlaneConnectorType.All) {
    return true;
  }
  return connectorType === _types.SwimlaneConnectorType.Alerts ? alertsFields.includes(fieldId) : casesFields.includes(fieldId);
};
exports.isValidFieldForConnector = isValidFieldForConnector;
const isRequiredField = (connectorType, fieldId) => {
  if (connectorType === _types.SwimlaneConnectorType.All) {
    return false;
  }
  if (fieldId == null || (0, _lodash.isEmpty)(fieldId)) {
    return true;
  }
  return connectorType === _types.SwimlaneConnectorType.Alerts ? alertsFields.includes(fieldId) : casesFields.includes(fieldId);
};
exports.isRequiredField = isRequiredField;
const validateMappingForConnector = (connectorType, mapping) => {
  if (connectorType === _types.SwimlaneConnectorType.All || connectorType == null) {
    return {};
  }
  const requiredFields = connectorType === _types.SwimlaneConnectorType.Alerts ? alertsRequiredFields : casesRequiredFields;
  return requiredFields.reduce((errors, field) => {
    if ((mapping === null || mapping === void 0 ? void 0 : mapping[field]) == null) {
      errors = {
        ...errors,
        [field]: translationMapping[field]
      };
    }
    return errors;
  }, {});
};
exports.validateMappingForConnector = validateMappingForConnector;