"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var i18n = _interopRequireWildcard(require("./translations"));
var _schema = require("./schema");
var _schema_utils = require("../schema_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JsonEditorComponent = ({
  editAction,
  index,
  messageVariables,
  subActionParams
}) => {
  const [jsonEditorErrors, setJsonEditorErrors] = (0, _react.useState)([]);
  const jsonEditorValue = (0, _react.useMemo)(() => getJsonEditorValue(subActionParams), [subActionParams]);
  const decodeJsonWithSchema = (0, _react.useCallback)(jsonBlob => {
    try {
      const decodedValue = (0, _schema.decodeCreateAlert)(jsonBlob);
      setJsonEditorErrors([]);
      return decodedValue;
    } catch (error) {
      if ((0, _schema_utils.isDecodeError)(error)) {
        setJsonEditorErrors(error.decodeErrors);
      } else {
        setJsonEditorErrors([error.message]);
      }
      return;
    }
  }, []);
  const onAdvancedEditorChange = (0, _react.useCallback)(json => {
    const parsedJson = parseJson(json);
    if (!parsedJson) {
      editAction('jsonEditorError', true, index);
      return;
    }
    const decodedValue = decodeJsonWithSchema(parsedJson);
    if (!decodedValue) {
      editAction('jsonEditorError', true, index);
      return;
    }
    editAction('subActionParams', decodedValue, index);
  }, [editAction, index, decodeJsonWithSchema]);
  (0, _react.useEffect)(() => {
    // show the initial error messages
    const decodedValue = decodeJsonWithSchema(subActionParams !== null && subActionParams !== void 0 ? subActionParams : {});
    if (!decodedValue) {
      editAction('jsonEditorError', true, index);
    } else {
      // must mark as undefined to remove the field so it is not sent to the server side
      editAction('jsonEditorError', undefined, index);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [subActionParams, decodeJsonWithSchema, index]);
  return /*#__PURE__*/_react.default.createElement(_public.JsonEditorWithMessageVariables, {
    messageVariables: messageVariables,
    paramsProperty: 'subActionParams',
    inputTargetValue: jsonEditorValue,
    "aria-label": i18n.JSON_EDITOR_ARIA,
    onDocumentsChange: onAdvancedEditorChange,
    errors: jsonEditorErrors,
    label: i18n.ALERT_FIELDS_LABEL
  });
};
JsonEditorComponent.displayName = 'JsonEditor';
const JsonEditor = /*#__PURE__*/_react.default.memo(JsonEditorComponent);

// eslint-disable-next-line import/no-default-export
exports.default = JsonEditor;
const parseJson = jsonValue => {
  try {
    return JSON.parse(jsonValue);
  } catch (error) {
    return;
  }
};
const getJsonEditorValue = subActionParams => {
  const defaultValue = '{}';
  try {
    const value = JSON.stringify(subActionParams, null, 2);
    if ((0, _lodash.isEmpty)(value)) {
      return defaultValue;
    }
    return value;
  } catch (error) {
    return defaultValue;
  }
};
module.exports = exports.default;