"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloseAlert = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _display_more_options = require("./display_more_options");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AdditionalOptions = ({
  subActionParams,
  editOptionalSubAction,
  index,
  messageVariables
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "opsgenie-source-row",
    fullWidth: true,
    label: i18n.SOURCE_FIELD_LABEL,
    helpText: i18n.OPSGENIE_SOURCE_HELP
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editOptionalSubAction,
    messageVariables: messageVariables,
    paramsProperty: 'source',
    inputTargetValue: subActionParams === null || subActionParams === void 0 ? void 0 : subActionParams.source
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "opsgenie-user-row",
    fullWidth: true,
    label: i18n.USER_FIELD_LABEL,
    helpText: i18n.OPSGENIE_USER_HELP
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editOptionalSubAction,
    messageVariables: messageVariables,
    paramsProperty: 'user',
    inputTargetValue: subActionParams === null || subActionParams === void 0 ? void 0 : subActionParams.user
  })))));
};
AdditionalOptions.displayName = 'AdditionalOptions';
const CloseAlertComponent = ({
  editSubAction,
  editOptionalSubAction,
  errors,
  index,
  messageVariables,
  subActionParams,
  showSaveError
}) => {
  const isAliasInvalid = errors['subActionParams.alias'] !== undefined && errors['subActionParams.alias'].length > 0 && (subActionParams === null || subActionParams === void 0 ? void 0 : subActionParams.alias) !== undefined || showSaveError;
  const [showingMoreOptions, setShowingMoreOptions] = (0, _react.useState)(false);
  const toggleShowingMoreOptions = (0, _react.useCallback)(() => setShowingMoreOptions(previousState => !previousState), []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "opsgenie-alias-row",
    fullWidth: true,
    error: errors['subActionParams.alias'],
    isInvalid: isAliasInvalid,
    label: i18n.ALIAS_FIELD_LABEL,
    helpText: i18n.OPSGENIE_ALIAS_HELP,
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, i18n.REQUIRED_LABEL)
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editSubAction,
    messageVariables: messageVariables,
    paramsProperty: 'alias',
    inputTargetValue: subActionParams === null || subActionParams === void 0 ? void 0 : subActionParams.alias,
    errors: errors['subActionParams.alias']
  })), /*#__PURE__*/_react.default.createElement(_public.TextAreaWithMessageVariables, {
    index: index,
    editAction: editOptionalSubAction,
    messageVariables: messageVariables,
    paramsProperty: 'note',
    inputTargetValue: subActionParams === null || subActionParams === void 0 ? void 0 : subActionParams.note,
    label: i18n.NOTE_FIELD_LABEL
  }), showingMoreOptions ? /*#__PURE__*/_react.default.createElement(AdditionalOptions, {
    subActionParams: subActionParams,
    index: index,
    messageVariables: messageVariables,
    editOptionalSubAction: editOptionalSubAction
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }), /*#__PURE__*/_react.default.createElement(_display_more_options.DisplayMoreOptions, {
    showingMoreOptions: showingMoreOptions,
    toggleShowingMoreOptions: toggleShowingMoreOptions
  }));
};
CloseAlertComponent.displayName = 'CloseAlert';
const CloseAlert = /*#__PURE__*/_react.default.memo(CloseAlertComponent);
exports.CloseAlert = CloseAlert;