"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CredentialsAuth = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField
} = _helpers.fieldValidators;
const CredentialsAuthComponent = ({
  isLoading,
  readOnly,
  pathPrefix = ''
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: `${pathPrefix}secrets.username`,
    component: _components.TextField,
    config: {
      label: i18n.USERNAME_LABEL,
      validations: [{
        validator: emptyField(i18n.USERNAME_REQUIRED)
      }]
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'connector-servicenow-username-form-input',
        isLoading,
        readOnly,
        disabled: readOnly || isLoading
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: `${pathPrefix}secrets.password`,
    config: {
      label: i18n.PASSWORD_LABEL,
      validations: [{
        validator: emptyField(i18n.PASSWORD_REQUIRED)
      }]
    },
    component: _components.PasswordField,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'connector-servicenow-password-form-input',
        isLoading,
        readOnly,
        disabled: readOnly || isLoading
      }
    }
  }));
};
const CredentialsAuth = /*#__PURE__*/(0, _react.memo)(CredentialsAuthComponent);
exports.CredentialsAuth = CredentialsAuth;