"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorType = getConnectorType;
exports.getEmailServices = getEmailServices;
var _lodash = require("lodash");
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/actions-plugin/common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const emailServices = [{
  text: _i18n.i18n.translate('xpack.stackConnectors.components.email.gmailServerTypeLabel', {
    defaultMessage: 'Gmail'
  }),
  value: 'gmail'
}, {
  text: _i18n.i18n.translate('xpack.stackConnectors.components.email.outlookServerTypeLabel', {
    defaultMessage: 'Outlook'
  }),
  value: 'outlook365'
}, {
  text: _i18n.i18n.translate('xpack.stackConnectors.components.email.amazonSesServerTypeLabel', {
    defaultMessage: 'Amazon SES'
  }),
  value: 'ses'
}, {
  text: _i18n.i18n.translate('xpack.stackConnectors.components.email.elasticCloudServerTypeLabel', {
    defaultMessage: 'Elastic Cloud'
  }),
  value: 'elastic_cloud'
}, {
  text: _i18n.i18n.translate('xpack.stackConnectors.components.email.exchangeServerTypeLabel', {
    defaultMessage: 'MS Exchange Server'
  }),
  value: 'exchange_server'
}, {
  text: _i18n.i18n.translate('xpack.stackConnectors.components.email.otherServerTypeLabel', {
    defaultMessage: 'Other'
  }),
  value: 'other'
}];
function getEmailServices(isCloudEnabled) {
  return isCloudEnabled ? emailServices : emailServices.filter(service => service.value !== 'elastic_cloud');
}
function getConnectorType(services) {
  return {
    id: '.email',
    iconClass: 'email',
    selectMessage: _i18n.i18n.translate('xpack.stackConnectors.components.email.selectMessageText', {
      defaultMessage: 'Send email from your server.'
    }),
    actionTypeTitle: _i18n.i18n.translate('xpack.stackConnectors.components.email.connectorTypeTitle', {
      defaultMessage: 'Send to email'
    }),
    validateParams: async actionParams => {
      var _actionParams$message, _actionParams$subject;
      const translations = await Promise.resolve().then(() => _interopRequireWildcard(require('./translations')));
      const errors = {
        to: new Array(),
        cc: new Array(),
        bcc: new Array(),
        message: new Array(),
        subject: new Array()
      };
      const validationResult = {
        errors
      };
      if (!((_actionParams$message = actionParams.message) !== null && _actionParams$message !== void 0 && _actionParams$message.length)) {
        errors.message.push(translations.MESSAGE_REQUIRED);
      }
      if (!((_actionParams$subject = actionParams.subject) !== null && _actionParams$subject !== void 0 && _actionParams$subject.length)) {
        errors.subject.push(translations.SUBJECT_REQUIRED);
      }
      const toEmails = getToFields(actionParams);
      const ccEmails = getCcFields(actionParams);
      const bccEmails = getBccFields(actionParams);
      if (toEmails.length === 0 && ccEmails.length === 0 && bccEmails.length === 0) {
        const errorText = translations.TO_CC_REQUIRED;
        errors.to.push(errorText);
        errors.cc.push(errorText);
        errors.bcc.push(errorText);
      }
      const allEmails = (0, _lodash.uniq)(toEmails.concat(ccEmails).concat(bccEmails));
      const validatedEmails = services.validateEmailAddresses(allEmails, {
        treatMustacheTemplatesAsValid: true
      });
      const toEmailSet = new Set(toEmails);
      const ccEmailSet = new Set(ccEmails);
      const bccEmailSet = new Set(bccEmails);
      for (const validated of validatedEmails) {
        if (!validated.valid) {
          const email = validated.address;
          const message = validated.reason === _common.InvalidEmailReason.notAllowed ? translations.getNotAllowedEmailAddress(email) : translations.getInvalidEmailAddress(email);
          if (toEmailSet.has(email)) errors.to.push(message);
          if (ccEmailSet.has(email)) errors.cc.push(message);
          if (bccEmailSet.has(email)) errors.bcc.push(message);
        }
      }
      return validationResult;
    },
    actionConnectorFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./email_connector')))),
    actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./email_params'))))
  };
}
function getToFields(actionParams) {
  if (!(actionParams.to instanceof Array)) return [];
  return actionParams.to;
}
function getCcFields(actionParams) {
  if (!(actionParams.cc instanceof Array)) return [];
  return actionParams.cc;
}
function getBccFields(actionParams) {
  if (!(actionParams.bcc instanceof Array)) return [];
  return actionParams.bcc;
}