"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _validator = require("../validator");
var _action_variables = require("../action_variables");
var _webhook_connectors = require("../webhook_connectors");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField,
  urlField
} = _helpers.fieldValidators;
const CreateStep = ({
  display,
  readOnly
}) => /*#__PURE__*/_react.default.createElement("span", {
  "data-test-subj": "createStep",
  style: {
    display: display ? 'block' : 'none'
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h3", null, i18n.STEP_2), /*#__PURE__*/_react.default.createElement("small", null, /*#__PURE__*/_react.default.createElement("p", null, i18n.STEP_2_DESCRIPTION))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "spaceBetween"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
  path: "config.createIncidentMethod",
  component: _components.Field,
  config: {
    label: i18n.CREATE_INCIDENT_METHOD,
    defaultValue: 'post',
    type: _hook_form_lib.FIELD_TYPES.SELECT,
    validations: [{
      validator: emptyField(i18n.CREATE_METHOD_REQUIRED)
    }]
  },
  componentProps: {
    euiFieldProps: {
      'data-test-subj': 'webhookCreateMethodSelect',
      options: _webhook_connectors.HTTP_VERBS.map(verb => ({
        text: verb.toUpperCase(),
        value: verb
      })),
      readOnly
    }
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
  path: "config.createIncidentUrl",
  config: {
    label: i18n.CREATE_INCIDENT_URL,
    validations: [{
      validator: urlField(i18n.CREATE_URL_REQUIRED)
    }]
  },
  component: _components.Field,
  componentProps: {
    euiFieldProps: {
      readOnly,
      'data-test-subj': 'webhookCreateUrlText'
    }
  }
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
  path: "config.createIncidentJson",
  config: {
    helpText: i18n.CREATE_INCIDENT_JSON_HELP,
    label: i18n.CREATE_INCIDENT_JSON,
    validations: [{
      validator: emptyField(i18n.CREATE_INCIDENT_REQUIRED)
    }, {
      validator: (0, _validator.containsTitleAndDesc)()
    }]
  },
  component: _public.JsonFieldWrapper,
  componentProps: {
    euiCodeEditorProps: {
      isReadOnly: readOnly,
      'data-test-subj': 'webhookCreateIncidentJson',
      ['aria-label']: i18n.CODE_EDITOR
    },
    messageVariables: _action_variables.casesVars,
    paramsProperty: 'createIncidentJson',
    buttonTitle: i18n.ADD_CASES_VARIABLE,
    showButtonTitle: true
  }
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
  path: "config.createIncidentResponseKey",
  config: {
    helpText: i18n.CREATE_INCIDENT_RESPONSE_KEY_HELP,
    label: i18n.CREATE_INCIDENT_RESPONSE_KEY,
    validations: [{
      validator: emptyField(i18n.CREATE_RESPONSE_KEY_REQUIRED)
    }]
  },
  component: _components.Field,
  componentProps: {
    euiFieldProps: {
      readOnly,
      'data-test-subj': 'createIncidentResponseKeyText'
    }
  }
}))));
exports.CreateStep = CreateStep;