"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamingResponseSchema = exports.StreamActionParamsSchema = exports.SecretsSchema = exports.RunActionResponseSchema = exports.RunActionParamsSchema = exports.InvokeAIActionResponseSchema = exports.InvokeAIActionParamsSchema = exports.DashboardActionResponseSchema = exports.DashboardActionParamsSchema = exports.ConfigSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Connector schema
const ConfigSchema = _configSchema.schema.oneOf([_configSchema.schema.object({
  apiProvider: _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.OpenAiProviderType.AzureAi)]),
  apiUrl: _configSchema.schema.string()
}), _configSchema.schema.object({
  apiProvider: _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.OpenAiProviderType.OpenAi)]),
  apiUrl: _configSchema.schema.string(),
  defaultModel: _configSchema.schema.string({
    defaultValue: _constants.DEFAULT_OPENAI_MODEL
  })
})]);
exports.ConfigSchema = ConfigSchema;
const SecretsSchema = _configSchema.schema.object({
  apiKey: _configSchema.schema.string()
});

// Run action schema
exports.SecretsSchema = SecretsSchema;
const RunActionParamsSchema = _configSchema.schema.object({
  body: _configSchema.schema.string()
});

// Run action schema
exports.RunActionParamsSchema = RunActionParamsSchema;
const InvokeAIActionParamsSchema = _configSchema.schema.object({
  messages: _configSchema.schema.arrayOf(_configSchema.schema.object({
    role: _configSchema.schema.string(),
    content: _configSchema.schema.string()
  })),
  model: _configSchema.schema.maybe(_configSchema.schema.string()),
  n: _configSchema.schema.maybe(_configSchema.schema.number()),
  stop: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())]))),
  temperature: _configSchema.schema.maybe(_configSchema.schema.number())
});
exports.InvokeAIActionParamsSchema = InvokeAIActionParamsSchema;
const InvokeAIActionResponseSchema = _configSchema.schema.object({
  message: _configSchema.schema.string(),
  usage: _configSchema.schema.object({
    prompt_tokens: _configSchema.schema.number(),
    completion_tokens: _configSchema.schema.number(),
    total_tokens: _configSchema.schema.number()
  }, {
    unknowns: 'ignore'
  })
});

// Execute action schema
exports.InvokeAIActionResponseSchema = InvokeAIActionResponseSchema;
const StreamActionParamsSchema = _configSchema.schema.object({
  body: _configSchema.schema.string(),
  stream: _configSchema.schema.boolean({
    defaultValue: false
  })
});
exports.StreamActionParamsSchema = StreamActionParamsSchema;
const StreamingResponseSchema = _configSchema.schema.any();
exports.StreamingResponseSchema = StreamingResponseSchema;
const RunActionResponseSchema = _configSchema.schema.object({
  id: _configSchema.schema.maybe(_configSchema.schema.string()),
  object: _configSchema.schema.maybe(_configSchema.schema.string()),
  created: _configSchema.schema.maybe(_configSchema.schema.number()),
  model: _configSchema.schema.maybe(_configSchema.schema.string()),
  usage: _configSchema.schema.object({
    prompt_tokens: _configSchema.schema.number(),
    completion_tokens: _configSchema.schema.number(),
    total_tokens: _configSchema.schema.number()
  }, {
    unknowns: 'ignore'
  }),
  choices: _configSchema.schema.arrayOf(_configSchema.schema.object({
    message: _configSchema.schema.object({
      role: _configSchema.schema.string(),
      content: _configSchema.schema.maybe(_configSchema.schema.string())
    }, {
      unknowns: 'ignore'
    }),
    finish_reason: _configSchema.schema.maybe(_configSchema.schema.string()),
    index: _configSchema.schema.maybe(_configSchema.schema.number())
  }, {
    unknowns: 'ignore'
  }))
}, {
  unknowns: 'ignore'
});

// Run action schema
exports.RunActionResponseSchema = RunActionResponseSchema;
const DashboardActionParamsSchema = _configSchema.schema.object({
  dashboardId: _configSchema.schema.string()
});
exports.DashboardActionParamsSchema = DashboardActionParamsSchema;
const DashboardActionResponseSchema = _configSchema.schema.object({
  available: _configSchema.schema.boolean()
});
exports.DashboardActionResponseSchema = DashboardActionResponseSchema;