"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchEsqlQuery = fetchEsqlQuery;
exports.getEsqlQuery = void 0;
var _common = require("@kbn/triggers-actions-ui-plugin/common");
var _common2 = require("../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function fetchEsqlQuery({
  ruleId,
  alertLimit,
  params,
  services,
  spacePrefix,
  publicBaseUrl,
  dateStart,
  dateEnd
}) {
  const {
    logger,
    scopedClusterClient
  } = services;
  const esClient = scopedClusterClient.asCurrentUser;
  const query = getEsqlQuery(params, alertLimit, dateStart, dateEnd);
  logger.debug(`ES|QL query rule (${ruleId}) query: ${JSON.stringify(query)}`);
  const response = await esClient.transport.request({
    method: 'POST',
    path: '/_esql',
    body: query
  });
  const link = `${publicBaseUrl}${spacePrefix}/app/management/insightsAndAlerting/triggersActions/rule/${ruleId}`;
  return {
    link,
    numMatches: Number(response.values.length),
    parsedResults: (0, _common.parseAggregationResults)({
      isCountAgg: true,
      isGroupAgg: false,
      esResult: {
        took: 0,
        timed_out: false,
        _shards: {
          failed: 0,
          successful: 0,
          total: 0
        },
        hits: (0, _common2.toEsQueryHits)(response)
      },
      resultLimit: alertLimit
    }),
    index: null
  };
}
const getEsqlQuery = (params, alertLimit, dateStart, dateEnd) => {
  const rangeFilter = [{
    range: {
      [params.timeField]: {
        lte: dateEnd,
        gt: dateStart,
        format: 'strict_date_optional_time'
      }
    }
  }];
  const query = {
    query: alertLimit ? `${params.esqlQuery.esql} | limit ${alertLimit}` : params.esqlQuery.esql,
    filter: {
      bool: {
        filter: rangeFilter
      }
    }
  };
  return query;
};
exports.getEsqlQuery = getEsqlQuery;